/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers;

import com.denizenscript.denizen.Settings;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;

public abstract class AbstractTrigger {
    protected String name;

    public AbstractTrigger as(String triggerName) {
        this.name = triggerName.toUpperCase();
        DenizenAPI.getCurrentInstance().getTriggerRegistry().register(triggerName, this);
        this.onEnable();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void onDisable() {
    }

    public void onEnable() {
    }

    public AbstractTrigger activate() {
        return this;
    }

    public boolean parse(NPCTag npc, PlayerTag player, InteractScriptContainer script) {
        return this.parse(npc, player, script, null, null);
    }

    public boolean parse(NPCTag npc, PlayerTag player, InteractScriptContainer script, String id) {
        return this.parse(npc, player, script, id, null);
    }

    public boolean parse(NPCTag npc, PlayerTag player, InteractScriptContainer script, String id, Map<String, ObjectTag> context) {
        if (npc == null || player == null || script == null) {
            return false;
        }
        List<ScriptEntry> entries = script.getEntriesFor(this.getClass(), player, npc, id, true);
        if (entries.isEmpty()) {
            return false;
        }
        Debug.echoDebug(script, Debug.DebugElement.Header, "Parsing " + this.name + " trigger: n@" + npc.getName() + "/p@" + player.getName());
        long speedTicks = script.contains("SPEED") ? DurationTag.valueOf(script.getString("SPEED", "0")).getTicks() : DurationTag.valueOf(Settings.interactQueueSpeed()).getTicks();
        ScriptQueue queue = speedTicks > 0L ? new TimedQueue(script.getName()).setSpeed(speedTicks).addEntries(entries) : new InstantQueue(script.getName()).addEntries(entries);
        queue.addEntries(entries);
        if (context != null) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = context;
            queue.setContextSource(oecs);
        }
        queue.start();
        return true;
    }

    public Set<NPC> getActiveNPCsWithinRangeWithTrigger(Location location, int maxRange) {
        HashSet<NPC> closestNPCs = new HashSet<NPC>();
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (!npc.isSpawned() || !npc.getEntity().getLocation().getWorld().equals(location.getWorld()) || !(npc.getEntity().getLocation().distance(location) < (double)maxRange) || !npc.hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getTrait(TriggerTrait.class)).isEnabled(this.name)) continue;
            closestNPCs.add(npc);
        }
        return closestNPCs;
    }
}

