/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers.core;

import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ProximityTrigger
extends AbstractTrigger
implements Listener {
    private static int maxProximityDistance = 75;
    int taskID = -1;
    private static Map<UUID, Set<Integer>> proximityTracker = new ConcurrentHashMap<UUID, Set<Integer>>(8, 0.9f, 1);

    @Override
    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        final ProximityTrigger trigger = this;
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                Collection allPlayers = Bukkit.getOnlinePlayers();
                for (NPC citizensNPC : CitizensAPI.getNPCRegistry()) {
                    if (citizensNPC == null || !citizensNPC.isSpawned() || !citizensNPC.hasTrait(TriggerTrait.class) || !((TriggerTrait)citizensNPC.getTrait(TriggerTrait.class)).isEnabled(ProximityTrigger.this.name)) continue;
                    NPCTag npc = new NPCTag(citizensNPC);
                    TriggerTrait triggerTrait = npc.getTriggerTrait();
                    for (Player bukkitPlayer : allPlayers) {
                        if (!npc.getWorld().equals(bukkitPlayer.getWorld()) && ProximityTrigger.this.hasExitedProximityOf(bukkitPlayer, npc) || !ProximityTrigger.this.isCloseEnough(bukkitPlayer, npc) && ProximityTrigger.this.hasExitedProximityOf(bukkitPlayer, npc)) continue;
                        PlayerTag player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)bukkitPlayer);
                        InteractScriptContainer script = npc.getInteractScriptQuietly(player, ProximityTrigger.class);
                        double entryRadius = triggerTrait.getRadius(ProximityTrigger.this.name);
                        double exitRadius = triggerTrait.getRadius(ProximityTrigger.this.name);
                        double moveRadius = triggerTrait.getRadius(ProximityTrigger.this.name);
                        if (script != null) {
                            try {
                                if (script.hasTriggerOptionFor(ProximityTrigger.class, player, null, "ENTRY RADIUS")) {
                                    entryRadius = Integer.valueOf(script.getTriggerOptionFor(ProximityTrigger.class, player, null, "ENTRY RADIUS")).intValue();
                                }
                            }
                            catch (NumberFormatException nfe) {
                                Debug.echoDebug((Debuggable)script, "Entry Radius was not an integer.  Assuming " + entryRadius + " as the radius.");
                            }
                            try {
                                if (script.hasTriggerOptionFor(ProximityTrigger.class, player, null, "EXIT RADIUS")) {
                                    exitRadius = Integer.valueOf(script.getTriggerOptionFor(ProximityTrigger.class, player, null, "EXIT RADIUS")).intValue();
                                }
                            }
                            catch (NumberFormatException nfe) {
                                Debug.echoDebug((Debuggable)script, "Exit Radius was not an integer.  Assuming " + exitRadius + " as the radius.");
                            }
                            try {
                                if (script.hasTriggerOptionFor(ProximityTrigger.class, player, null, "MOVE RADIUS")) {
                                    moveRadius = Integer.valueOf(script.getTriggerOptionFor(ProximityTrigger.class, player, null, "MOVE RADIUS")).intValue();
                                }
                            }
                            catch (NumberFormatException nfe) {
                                Debug.echoDebug((Debuggable)script, "Move Radius was not an integer.  Assuming " + moveRadius + " as the radius.");
                            }
                        }
                        LocationTag npcLocation = npc.getLocation();
                        boolean playerChangedWorlds = false;
                        if (npcLocation.getWorld() != player.getWorld()) {
                            playerChangedWorlds = true;
                        }
                        boolean exitedProximity = ProximityTrigger.this.hasExitedProximityOf(bukkitPlayer, npc);
                        double distance = 0.0;
                        if (!playerChangedWorlds) {
                            distance = npcLocation.distance(player.getLocation());
                        }
                        if (!exitedProximity && (playerChangedWorlds || distance >= exitRadius)) {
                            if (!triggerTrait.triggerCooldownOnly(trigger, player)) continue;
                            ProximityTrigger.this.exitProximityOf(bukkitPlayer, npc);
                            npc.action("exit proximity", player);
                            ProximityTrigger.this.parse(npc, player, script, "EXIT");
                            continue;
                        }
                        if (exitedProximity && distance <= entryRadius) {
                            if (!triggerTrait.triggerCooldownOnly(trigger, player)) continue;
                            ProximityTrigger.this.enterProximityOf(bukkitPlayer, npc);
                            npc.action("enter proximity", player);
                            ProximityTrigger.this.parse(npc, player, script, "ENTRY");
                            continue;
                        }
                        if (exitedProximity || !(distance <= moveRadius)) continue;
                        npc.action("move proximity", player);
                        ProximityTrigger.this.parse(npc, player, script, "MOVE");
                    }
                }
            }
        }, 5L, 5L);
    }

    @Override
    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.taskID);
    }

    private boolean isCloseEnough(Player player, NPCTag npc) {
        Location pLoc = player.getLocation();
        LocationTag nLoc = npc.getLocation();
        if (Math.abs(pLoc.getX() - nLoc.getX()) > (double)maxProximityDistance) {
            return false;
        }
        if (Math.abs(pLoc.getY() - nLoc.getY()) > (double)maxProximityDistance) {
            return false;
        }
        return !(Math.abs(pLoc.getZ() - nLoc.getZ()) > (double)maxProximityDistance);
    }

    @EventHandler
    public void checkMaxProximities(ScriptReloadEvent event) {
        for (String string : ScriptRegistry._getScriptNames()) {
        }
    }

    private boolean hasExitedProximityOf(Player player, NPCTag npc) {
        Set<Integer> existing = proximityTracker.get(player.getUniqueId());
        if (existing == null) {
            return true;
        }
        return !existing.contains(npc.getId());
    }

    private void enterProximityOf(Player player, NPCTag npc) {
        Set<Integer> npcs = proximityTracker.get(player.getUniqueId());
        if (npcs == null) {
            npcs = new HashSet<Integer>();
            proximityTracker.put(player.getUniqueId(), npcs);
        }
        npcs.add(npc.getId());
    }

    private void exitProximityOf(Player player, NPCTag npc) {
        Set<Integer> npcs = proximityTracker.get(player.getUniqueId());
        if (npcs == null) {
            npcs = new HashSet<Integer>();
            proximityTracker.put(player.getUniqueId(), npcs);
        }
        npcs.remove(npc.getId());
    }
}

