/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class Conversion {
    public static List<Color> convertColors(List<ColorTag> colors) {
        ArrayList<Color> newList = new ArrayList<Color>();
        for (ColorTag color : colors) {
            newList.add(color.getColor());
        }
        return newList;
    }

    public static List<ItemStack> convertItems(List<ItemTag> items) {
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
        for (ItemTag item : items) {
            newList.add(item.getItemStack());
        }
        return newList;
    }

    public static List<Entity> convertEntities(List<EntityTag> entities) {
        ArrayList<Entity> newList = new ArrayList<Entity>();
        for (EntityTag entity : entities) {
            newList.add(entity.getBukkitEntity());
        }
        return newList;
    }

    public static AbstractMap.SimpleEntry<Integer, InventoryTag> getInventory(Argument arg, ScriptEntry scriptEntry) {
        String string = arg.getValue();
        if (InventoryTag.matches(string)) {
            BukkitScriptEntryData data = (BukkitScriptEntryData)scriptEntry.entryData;
            if (data != null) {
                InventoryTag inv = InventoryTag.valueOf(string, data.getTagContext());
                if (inv != null) {
                    return new AbstractMap.SimpleEntry<Integer, InventoryTag>(inv.getContents().length, inv);
                }
            } else {
                InventoryTag inv = InventoryTag.valueOf(string, null);
                if (inv != null) {
                    return new AbstractMap.SimpleEntry<Integer, InventoryTag>(inv.getContents().length, inv);
                }
            }
        } else {
            if (arg.matchesArgumentList(ItemTag.class)) {
                List<ItemTag> list = ListTag.valueOf(string).filter(ItemTag.class, scriptEntry);
                ItemStack[] items = Conversion.convertItems(list).toArray(new ItemStack[list.size()]);
                InventoryTag inventory = new InventoryTag(Math.max(54, items.length / 9 * 9 + 9));
                inventory.setContents(items);
                return new AbstractMap.SimpleEntry<Integer, InventoryTag>(items.length, inventory);
            }
            if (LocationTag.matches(string)) {
                InventoryTag inv = LocationTag.valueOf(string).getInventory();
                return new AbstractMap.SimpleEntry<Integer, InventoryTag>(inv.getContents().length, inv);
            }
            if (EntityTag.matches(string)) {
                InventoryTag inv = EntityTag.valueOf(string).getInventory();
                return new AbstractMap.SimpleEntry<Integer, InventoryTag>(inv.getContents().length, inv);
            }
        }
        return null;
    }
}

