/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command;

import com.denizenscript.denizen.utilities.command.Command;
import com.denizenscript.denizen.utilities.command.CommandAnnotationProcessor;
import com.denizenscript.denizen.utilities.command.CommandContext;
import com.denizenscript.denizen.utilities.command.Injector;
import com.denizenscript.denizen.utilities.command.Paginator;
import com.denizenscript.denizen.utilities.command.RequirementsProcessor;
import com.denizenscript.denizen.utilities.command.exceptions.CommandException;
import com.denizenscript.denizen.utilities.command.exceptions.CommandUsageException;
import com.denizenscript.denizen.utilities.command.exceptions.NoPermissionsException;
import com.denizenscript.denizen.utilities.command.exceptions.ServerCommandException;
import com.denizenscript.denizen.utilities.command.exceptions.UnhandledCommandException;
import com.denizenscript.denizen.utilities.command.exceptions.WrappedCommandException;
import com.denizenscript.denizen.utilities.command.messaging.Messaging;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandManager {
    private final Map<Class<? extends Annotation>, CommandAnnotationProcessor> annotationProcessors = new HashMap<Class<? extends Annotation>, CommandAnnotationProcessor>();
    private final Map<String, Method> commands = new HashMap<String, Method>();
    private Injector injector;
    private final Map<Method, Object> instances = new HashMap<Method, Object>();
    private final ListMultimap<Method, Annotation> registeredAnnotations = ArrayListMultimap.create();
    private final Set<Method> serverCommands = new HashSet<Method>();
    private static final String COMMAND_FORMAT = "<7>/<c>%s%s <7>- <e>%s";

    public CommandManager() {
        this.registerAnnotationProcessor(new RequirementsProcessor());
    }

    public void execute(org.bukkit.command.Command command, String[] args, CommandSender sender, Object ... methodArgs) throws CommandException {
        String[] newArgs = new String[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = CoreUtilities.toLowerCase(command.getName());
        Object[] newMethodArgs = new Object[methodArgs.length + 1];
        System.arraycopy(methodArgs, 0, newMethodArgs, 1, methodArgs.length);
        this.executeMethod(newArgs, sender, newMethodArgs);
    }

    private void executeHelp(String[] args, CommandSender sender) throws CommandException {
        if (!sender.hasPermission("denizen.basic")) {
            throw new NoPermissionsException();
        }
        int page = 1;
        try {
            page = args.length == 3 ? Integer.parseInt(args[2]) : page;
        }
        catch (NumberFormatException e) {
            this.sendSpecificHelp(sender, args[0], args[2]);
            return;
        }
        this.sendHelp(sender, args[0], page);
    }

    private void executeMethod(String[] args, CommandSender sender, Object[] methodArgs) throws CommandException {
        String cmdName = CoreUtilities.toLowerCase(args[0]);
        String modifier = args.length > 1 ? args[1] : "";
        boolean help = CoreUtilities.toLowerCase(modifier).equals("help");
        Method method = this.commands.get(cmdName + " " + CoreUtilities.toLowerCase(modifier));
        if (method == null && !help) {
            method = this.commands.get(cmdName + " *");
        }
        if (method == null && help) {
            this.executeHelp(args, sender);
            return;
        }
        if (method == null) {
            throw new UnhandledCommandException();
        }
        if (!this.serverCommands.contains(method) && sender instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        if (!this.hasPermission(method, sender)) {
            throw new NoPermissionsException();
        }
        Command cmd = method.getAnnotation(Command.class);
        CommandContext context = new CommandContext(sender, args);
        if (context.argsLength() < cmd.min()) {
            throw new CommandUsageException("Too few arguments.", this.getUsage(args, cmd));
        }
        if (cmd.max() != -1 && context.argsLength() > cmd.max()) {
            throw new CommandUsageException("Too many arguments.", this.getUsage(args, cmd));
        }
        if (!cmd.flags().contains("*")) {
            for (char flag : context.getFlags()) {
                if (cmd.flags().indexOf(String.valueOf(flag)) != -1) continue;
                throw new CommandUsageException("Unknown flag: " + flag, this.getUsage(args, cmd));
            }
        }
        methodArgs[0] = context;
        for (Annotation annotation : this.registeredAnnotations.get((Object)method)) {
            CommandAnnotationProcessor processor = this.annotationProcessors.get(annotation.annotationType());
            processor.process(sender, context, annotation, methodArgs);
        }
        Object instance = this.instances.get(method);
        try {
            method.invoke(instance, methodArgs);
        }
        catch (IllegalArgumentException e) {
            Debug.echoError(e);
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CommandException) {
                throw (CommandException)e.getCause();
            }
            throw new WrappedCommandException(e.getCause());
        }
    }

    public boolean executeSafe(org.bukkit.command.Command command, String[] args, CommandSender sender, Object ... methodArgs) {
        block9: {
            try {
                try {
                    this.execute(command, args, sender, methodArgs);
                }
                catch (ServerCommandException ex) {
                    Messaging.send(sender, "You must be ingame to use that command.");
                }
                catch (CommandUsageException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                    Messaging.sendError(sender, ex.getUsage());
                }
                catch (UnhandledCommandException ex) {
                    return false;
                }
                catch (WrappedCommandException ex) {
                    throw ex.getCause();
                }
                catch (CommandException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    Messaging.sendError(sender, "That is not a valid number.");
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
                if (!(sender instanceof Player)) break block9;
                Messaging.sendError(sender, "Please report this error: [See console]");
                Messaging.sendError(sender, ex.getClass().getName() + ": " + ex.getMessage());
            }
        }
        return true;
    }

    public String getClosestCommandModifier(String command, String modifier) {
        int minDist = Integer.MAX_VALUE;
        command = CoreUtilities.toLowerCase(command);
        String closest = "";
        for (String cmd : this.commands.keySet()) {
            int distance;
            String[] split = cmd.split(" ");
            if (split.length <= 1 || !split[0].equals(command) || minDist <= (distance = CommandManager.getLevenshteinDistance(modifier, split[1]))) continue;
            minDist = distance;
            closest = split[1];
        }
        return closest;
    }

    public CommandInfo getCommand(String rootCommand, String modifier) {
        String joined = rootCommand + ' ' + modifier;
        for (Map.Entry<String, Method> entry : this.commands.entrySet()) {
            Command commandAnnotation;
            if (!entry.getKey().equalsIgnoreCase(joined) || entry.getValue() == null || (commandAnnotation = entry.getValue().getAnnotation(Command.class)) == null) continue;
            return new CommandInfo(commandAnnotation);
        }
        return null;
    }

    public List<CommandInfo> getCommands(String command) {
        ArrayList<CommandInfo> cmds = new ArrayList<CommandInfo>();
        command = CoreUtilities.toLowerCase(command);
        for (Map.Entry<String, Method> entry : this.commands.entrySet()) {
            Command commandAnnotation;
            if (!entry.getKey().startsWith(command) || entry.getValue() == null || (commandAnnotation = entry.getValue().getAnnotation(Command.class)) == null) continue;
            cmds.add(new CommandInfo(commandAnnotation));
        }
        return cmds;
    }

    private List<String> getLines(CommandSender sender, String baseCommand) {
        HashSet<CommandInfo> processed = new HashSet<CommandInfo>();
        ArrayList<String> lines = new ArrayList<String>();
        for (CommandInfo info : this.getCommands(baseCommand)) {
            Command command = info.getCommandAnnotation();
            if (processed.contains(info) || !sender.hasPermission(command.permission())) continue;
            lines.add(CommandManager.format(command, baseCommand));
            if (command.modifiers().length <= 1) continue;
            processed.add(info);
        }
        return lines;
    }

    private String getUsage(String[] args, Command cmd) {
        return "/" + args[0] + " " + cmd.usage();
    }

    public boolean hasCommand(org.bukkit.command.Command cmd, String modifier) {
        String cmdName = CoreUtilities.toLowerCase(cmd.getName());
        return this.commands.containsKey(cmdName + " " + CoreUtilities.toLowerCase(modifier)) || this.commands.containsKey(cmdName + " *");
    }

    private boolean hasPermission(CommandSender sender, String perm) {
        return sender.hasPermission(perm);
    }

    private boolean hasPermission(Method method, CommandSender sender) {
        Command cmd = method.getAnnotation(Command.class);
        return cmd.permission().isEmpty() || this.hasPermission(sender, cmd.permission()) || this.hasPermission(sender, "admin");
    }

    public void register(Class<?> clazz) {
        this.registerMethods(clazz, null);
    }

    public void registerAnnotationProcessor(CommandAnnotationProcessor processor) {
        this.annotationProcessors.put(processor.getAnnotationClass(), processor);
    }

    private void registerMethods(Class<?> clazz, Method parent) {
        Object obj = this.injector != null ? this.injector.getInstance(clazz) : null;
        this.registerMethods(clazz, parent, obj);
    }

    private void registerMethods(Class<?> clazz, Method parent, Object obj) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.isAnnotationPresent(Command.class)) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                if (obj == null) continue;
                this.instances.put(method, obj);
            }
            Command cmd = method.getAnnotation(Command.class);
            for (String alias : cmd.aliases()) {
                for (String modifier : cmd.modifiers()) {
                    this.commands.put(alias + " " + modifier, method);
                }
                if (this.commands.containsKey(alias + " help")) continue;
                this.commands.put(alias + " help", null);
            }
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (Annotation annotation : method.getDeclaringClass().getAnnotations()) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                if (!this.annotationProcessors.containsKey(annotationClass)) continue;
                annotations.add(annotation);
            }
            for (Annotation annotation : method.getAnnotations()) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                if (!this.annotationProcessors.containsKey(annotationClass)) continue;
                Iterator itr = annotations.iterator();
                while (itr.hasNext()) {
                    Annotation previous = (Annotation)itr.next();
                    if (previous.annotationType() != annotationClass) continue;
                    itr.remove();
                }
                annotations.add(annotation);
            }
            if (annotations.size() > 0) {
                this.registeredAnnotations.putAll((Object)method, annotations);
            }
            if ((parameterTypes = method.getParameterTypes()).length > 1 && parameterTypes[1] != CommandSender.class) continue;
            this.serverCommands.add(method);
        }
    }

    private void sendHelp(CommandSender sender, String name, int page) throws CommandException {
        if (name.equalsIgnoreCase("npc")) {
            name = "NPC";
        }
        Paginator paginator = new Paginator().header(CommandManager.capitalize(name) + " Help");
        for (String line : this.getLines(sender, CoreUtilities.toLowerCase(name))) {
            paginator.addLine(line);
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("The page " + page + " does not exist.");
        }
    }

    private void sendSpecificHelp(CommandSender sender, String rootCommand, String modifier) throws CommandException {
        CommandInfo info = this.getCommand(rootCommand, modifier);
        if (info == null) {
            throw new CommandException("Command /" + rootCommand + " " + modifier + " not found.");
        }
        Messaging.send(sender, CommandManager.format(info.getCommandAnnotation(), rootCommand));
        if (info.getCommandAnnotation().help().isEmpty()) {
            return;
        }
        Messaging.send(sender, "<b>" + info.getCommandAnnotation().help());
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    private static String capitalize(Object string) {
        String capitalize = string.toString();
        return capitalize.length() == 0 ? "" : Character.toUpperCase(capitalize.charAt(0)) + capitalize.substring(1);
    }

    private static String format(Command command, String alias) {
        return String.format(COMMAND_FORMAT, alias, command.usage().isEmpty() ? "" : " " + command.usage(), command.desc());
    }

    private static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static class CommandInfo {
        private final Command commandAnnotation;

        public CommandInfo(Command commandAnnotation) {
            this.commandAnnotation = commandAnnotation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CommandInfo other = (CommandInfo)obj;
            return !(this.commandAnnotation == null ? other.commandAnnotation != null : !this.commandAnnotation.equals(other.commandAnnotation));
        }

        public Command getCommandAnnotation() {
            return this.commandAnnotation;
        }

        public int hashCode() {
            return 31 + (this.commandAnnotation == null ? 0 : this.commandAnnotation.hashCode());
        }
    }
}

