/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArgumentHelper {
    static final Pattern floatPrimitive;
    static final Pattern doublePrimitive;
    static final Pattern percentagePrimitive;
    static final Pattern integerPrimitive;
    static final Pattern booleanPrimitive;
    static final Pattern wordPrimitive;
    public static List<String> specialInterpretTrickStrings;
    public static List<Argument> specialInterpretTrickObjects;
    static final Pattern matchesScriptPtrn;

    public static List<Argument> interpretObjects(List<ObjectTag> args) {
        ArrayList<Argument> arg_list = new ArrayList<Argument>(args.size());
        for (ObjectTag obj : args) {
            arg_list.add(new Argument(obj));
        }
        return arg_list;
    }

    public static List<Argument> interpretArguments(List<Argument> args) {
        for (Argument arg : args) {
            if (!arg.needsFill && !arg.hasSpecialPrefix) continue;
            if (arg.object instanceof ElementTag && arg.prefix == null) {
                arg.fillStr(arg.object.toString());
                continue;
            }
            arg.value = arg.object.toString();
            arg.lower_value = CoreUtilities.toLowerCase(arg.value);
            arg.raw_value = arg.generateRaw();
        }
        return args;
    }

    public static List<Argument> interpret(List<String> args) {
        if (args == specialInterpretTrickStrings) {
            return ArgumentHelper.interpretArguments(specialInterpretTrickObjects);
        }
        ArrayList<Argument> arg_list = new ArrayList<Argument>(args.size());
        for (String string : args) {
            arg_list.add(new Argument(string));
        }
        return arg_list;
    }

    public static String[] buildArgs(String stringArgs) {
        if (stringArgs == null) {
            return null;
        }
        stringArgs = stringArgs.trim();
        stringArgs = stringArgs.replace('\r', ' ').replace('\n', ' ');
        ArrayList<String> matchList = new ArrayList<String>();
        int start = 0;
        int len = stringArgs.length();
        char currentQuote = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = stringArgs.charAt(i);
            if (c == ' ' && currentQuote == '\u0000') {
                if (i > start) {
                    matchList.add(stringArgs.substring(start, i));
                }
                start = i + 1;
                continue;
            }
            if (c != '\"' && c != '\'') continue;
            if (currentQuote == '\u0000') {
                if (i - 1 >= 0 && stringArgs.charAt(i - 1) != ' ') continue;
                currentQuote = c;
                start = i + 1;
                continue;
            }
            if (currentQuote != c || i + 1 < len && stringArgs.charAt(i + 1) != ' ') continue;
            currentQuote = '\u0000';
            if (i >= start) {
                matchList.add(stringArgs.substring(start, i));
            }
            start = ++i + 1;
        }
        if (start < len) {
            matchList.add(stringArgs.substring(start));
        }
        if (Debug.showScriptBuilder) {
            Debug.log("Constructed args: " + Arrays.toString(matchList.toArray()));
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    public static String debugObj(String prefix, Object value) {
        return "<G>" + prefix + "='<Y>" + (value != null ? (value instanceof ObjectTag ? ((ObjectTag)value).debuggable() : value.toString()) : "null") + "<G>'  ";
    }

    public static <T extends ObjectTag> String debugList(String prefix, Collection<T> objects) {
        if (objects == null) {
            return ArgumentHelper.debugObj(prefix, null);
        }
        StringBuilder sb = new StringBuilder();
        for (ObjectTag obj : objects) {
            sb.append(obj.debuggable()).append("<G>, ");
        }
        if (sb.length() == 0) {
            return ArgumentHelper.debugObj(prefix, sb);
        }
        return ArgumentHelper.debugObj(prefix, "[" + sb.substring(0, sb.length() - "<G>, ".length()) + "<Y>]");
    }

    public static String debugUniqueObj(String prefix, String id, Object value) {
        return "<G>" + prefix + "='<A>" + id + "<Y>(" + (value != null ? value.toString() : "null") + ")<G>'  ";
    }

    public static boolean matchesArg(String names, String string_arg) {
        String[] parts = names.split(",");
        if (parts.length == 1) {
            if (string_arg.toUpperCase().equals(names.toUpperCase())) {
                return true;
            }
        } else {
            for (String string : parts) {
                if (!string_arg.split(":")[0].equalsIgnoreCase(string.trim())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean matchesValueArg(String names, String string_arg, ArgumentType type) {
        if (string_arg == null) {
            return false;
        }
        int firstColonIndex = string_arg.indexOf(58);
        if (firstColonIndex == -1) {
            return false;
        }
        String[] commaParts = names.split(",");
        if (commaParts.length == 1) {
            if (!string_arg.substring(0, firstColonIndex).equalsIgnoreCase(names)) {
                return false;
            }
        } else {
            boolean matched = false;
            for (String string : commaParts) {
                if (!string_arg.substring(0, firstColonIndex).equalsIgnoreCase(string.trim())) continue;
                matched = true;
            }
            if (!matched) {
                return false;
            }
        }
        string_arg = string_arg.split(":", 2)[1];
        switch (type) {
            case Word: {
                return wordPrimitive.matcher(string_arg).matches();
            }
            case Integer: {
                return doublePrimitive.matcher(string_arg).matches();
            }
            case Double: {
                return doublePrimitive.matcher(string_arg).matches();
            }
            case Float: {
                return floatPrimitive.matcher(string_arg).matches();
            }
            case Boolean: {
                return booleanPrimitive.matcher(string_arg).matches();
            }
            case Script: {
                return true;
            }
            case String: {
                return true;
            }
            case Custom: {
                return true;
            }
        }
        Debug.echoError("Invalid or temporarily unavailable matches value!");
        Debug.echoError("While parsing '" + string_arg + "', Denizen has run into a problem. While the prefix is correct, the value is not valid. Check documentation for valid value.Perhaps a replaceable tag has failed to fill in a value?");
        return false;
    }

    public static boolean getBooleanFrom(String arg) {
        return Boolean.valueOf(ArgumentHelper.getStringFrom(arg));
    }

    public static double getDoubleFrom(String arg) {
        try {
            return Double.valueOf(ArgumentHelper.getStringFrom(arg));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static float getFloatFrom(String arg) {
        try {
            return Float.valueOf(ArgumentHelper.getStringFrom(arg)).floatValue();
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static int getIntegerFrom(String arg) {
        try {
            return Double.valueOf(ArgumentHelper.getStringFrom(arg)).intValue();
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Deprecated
    public static ListTag getListFrom(String arg) {
        return ListTag.valueOf(ArgumentHelper.getStringFrom(arg));
    }

    public static long getLongFrom(String arg) {
        try {
            return Long.valueOf(arg);
        }
        catch (NumberFormatException ex) {
            try {
                return Double.valueOf(ArgumentHelper.getStringFrom(arg)).longValue();
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
    }

    @Deprecated
    public static ScriptTag getScriptFrom(String arg) {
        arg = CoreUtilities.toLowerCase(arg).replace("script:", "");
        return ScriptTag.valueOf(arg);
    }

    public static String getStringFrom(String arg) {
        String[] parts = arg.split(":", 2);
        return parts.length >= 2 ? parts[1] : arg;
    }

    @Deprecated
    public static DurationTag getDurationFrom(String arg) {
        arg = CoreUtilities.toLowerCase(arg).replace("duration:", "").replace("delay:", "");
        return DurationTag.valueOf(arg);
    }

    public static boolean matchesDouble(String arg) {
        return doublePrimitive.matcher(arg).matches();
    }

    @Deprecated
    public static boolean matchesDuration(String arg) {
        arg = CoreUtilities.toLowerCase(arg).replace("duration:", "").replace("delay:", "");
        return DurationTag.matches(arg);
    }

    public static boolean matchesInteger(String arg) {
        return doublePrimitive.matcher(arg).matches();
    }

    @Deprecated
    public static boolean matchesItem(String arg) {
        return arg.length() > 5 && arg.toUpperCase().startsWith("ITEM:");
    }

    @Deprecated
    public static boolean matchesContext(String arg) {
        return arg.toUpperCase().startsWith("CONTEXT:") || arg.toUpperCase().startsWith("DEFINE:");
    }

    @Deprecated
    public static Map<String, String> getContextFrom(String arg) {
        HashMap<String, String> context = new HashMap<String, String>();
        int x = 1;
        for (String ctxt : ArgumentHelper.getListFrom(arg)) {
            context.put(String.valueOf(x), ctxt.trim());
            ++x;
        }
        return context;
    }

    @Deprecated
    public static boolean matchesLocation(String arg) {
        return arg.toUpperCase().startsWith("LOCATION:");
    }

    @Deprecated
    public static boolean matchesQuantity(String arg) {
        return arg.toUpperCase().startsWith("QTY:");
    }

    @Deprecated
    public static boolean matchesQueue(String arg) {
        return arg.toUpperCase().startsWith("QUEUE:");
    }

    @Deprecated
    public static boolean matchesScript(String arg) {
        Matcher m = matchesScriptPtrn.matcher(arg);
        if (m.matches()) {
            if (ScriptRegistry.containsScript(m.group(1))) {
                return true;
            }
            Debug.echoError("While parsing '" + arg + "', Denizen has run into a problem. This argument's format is correct, but Denizen couldn't locate a script named '" + m.group(1) + "'. Is it spelled correctly?");
        }
        return false;
    }

    @Deprecated
    public static boolean matchesState(String arg) {
        Pattern m = Pattern.compile("(state|toggle):(true|false|toggle)");
        if (m.matcher(arg).matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("(state|toggle):")) {
            Debug.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the prefix is correct, the value is not valid. 'STATE' requires a value of TRUE, FALSE, or TOGGLE. ");
        }
        return false;
    }

    static {
        doublePrimitive = floatPrimitive = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
        percentagePrimitive = Pattern.compile("-?(?:\\d+)?(\\.\\d+)?(%)?");
        integerPrimitive = Pattern.compile("(-)?\\d+");
        booleanPrimitive = Pattern.compile("true|false", 2);
        wordPrimitive = Pattern.compile("\\w+");
        specialInterpretTrickStrings = null;
        specialInterpretTrickObjects = null;
        matchesScriptPtrn = Pattern.compile("script:(.+)", 2);
    }

    public static enum ArgumentType {
        LivingEntity,
        Item,
        Boolean,
        Custom,
        Double,
        Float,
        Integer,
        String,
        Word,
        Location,
        Script,
        Duration;

    }

    public static enum PrimitiveType {
        Float,
        Double,
        Integer,
        Boolean,
        String,
        Word,
        Percentage;

    }
}

