/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.file;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class FileCopyCommand
extends AbstractCommand
implements Holdable {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin", "o")) {
                scriptEntry.addObject("origin", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesPrefix("destination", "d")) {
                scriptEntry.addObject("destination", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("overwrite") && arg.matches("overwrite")) {
                scriptEntry.addObject("overwrite", new ElementTag("true"));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("origin")) {
            throw new InvalidArgumentsException("Must have a valid origin!");
        }
        if (!scriptEntry.hasObject("destination")) {
            throw new InvalidArgumentsException("Must have a valid destination!");
        }
        scriptEntry.defaultObject("overwrite", new ElementTag("false"));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        boolean disdir;
        ElementTag origin = scriptEntry.getElement("origin");
        ElementTag destination = scriptEntry.getElement("destination");
        ElementTag overwrite = scriptEntry.getElement("overwrite");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), origin.debug() + destination.debug() + overwrite.debug());
        }
        if (!DenizenCore.getImplementation().allowFileCopy()) {
            Debug.echoError(scriptEntry.getResidingQueue(), "File copy disabled by server administrator.");
            scriptEntry.addObject("success", new ElementTag("false"));
            scriptEntry.setFinished(true);
            return;
        }
        final File o = new File(DenizenCore.getImplementation().getDataFolder(), origin.asString());
        final File d = new File(DenizenCore.getImplementation().getDataFolder(), destination.asString());
        boolean ow = overwrite.asBoolean();
        final boolean dexists = d.exists();
        boolean bl = disdir = d.isDirectory() || destination.asString().endsWith("/");
        if (!DenizenCore.getImplementation().canReadFile(o)) {
            Debug.echoError("Server config denies reading files in that location.");
            scriptEntry.addObject("success", new ElementTag("false"));
            scriptEntry.setFinished(true);
            return;
        }
        if (!o.exists()) {
            Debug.echoError(scriptEntry.getResidingQueue(), "File copy failed, origin does not exist!");
            scriptEntry.addObject("success", new ElementTag("false"));
            scriptEntry.setFinished(true);
            return;
        }
        if (!DenizenCore.getImplementation().canWriteToFile(d)) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Can't copy files to there!");
            scriptEntry.addObject("success", new ElementTag("false"));
            scriptEntry.setFinished(true);
            return;
        }
        if (dexists && !disdir && !ow) {
            Debug.echoDebug((Debuggable)scriptEntry, "File copy ignored, destination file already exists!");
            scriptEntry.addObject("success", new ElementTag("false"));
            scriptEntry.setFinished(true);
            return;
        }
        Runnable runme = new Runnable(){

            @Override
            public void run() {
                try {
                    if (dexists && !disdir) {
                        d.delete();
                    }
                    if (disdir && !dexists) {
                        d.mkdirs();
                    }
                    if (o.isDirectory()) {
                        CoreUtilities.copyDirectory(o, d);
                    } else {
                        Files.copy(o.toPath(), disdir ? d.toPath().resolve(o.toPath().getFileName()) : d.toPath(), new CopyOption[0]);
                    }
                    scriptEntry.addObject("success", new ElementTag("true"));
                    scriptEntry.setFinished(true);
                }
                catch (Exception e) {
                    Debug.echoError(scriptEntry.getResidingQueue(), e);
                    scriptEntry.addObject("success", new ElementTag("false"));
                    scriptEntry.setFinished(true);
                }
            }
        };
        if (scriptEntry.shouldWaitFor()) {
            DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(runme, 0.0f)));
        } else {
            runme.run();
        }
    }
}

