/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags.core;

import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class EscapeTagBase {
    public EscapeTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                EscapeTagBase.this.escapeTags(event);
            }
        }, "escape");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                EscapeTagBase.this.unEscapeTags(event);
            }
        }, "unescape");
    }

    public static String escape(String input) {
        if (input == null) {
            return null;
        }
        return TagManager.cleanOutputFully(input).replace("&", "&amp").replace("|", "&pipe").replace(">", "&gt").replace("<", "&lt").replace("\n", "&nl").replace(";", "&sc").replace("[", "&lb").replace("]", "&rb").replace(":", "&co").replace("@", "&at").replace(".", "&dot").replace("\\", "&bs").replace("'", "&sq").replace("\"", "&quo").replace("!", "&exc").replace("/", "&fs").replace("\u00a7", "&ss").replace("#", "&ns");
    }

    public static String unEscape(String input) {
        if (input == null) {
            return null;
        }
        return TagManager.cleanOutputFully(input).replace("&pipe", "|").replace("&nl", "\n").replace("&gt", ">").replace("&lt", "<").replace("&sc", ";").replace("&sq", "'").replace("&lb", "[").replace("&rb", "]").replace("&sp", String.valueOf('\u00a0')).replace("&co", ":").replace("&at", "@").replace("&dot", ".").replace("&bs", "\\").replace("&quo", "\"").replace("&exc", "!").replace("&fs", "/").replace("&ss", "\u00a7").replace("&ns", "#").replace("&amp", "&");
    }

    public void escapeTags(ReplaceableTagEvent event) {
        Deprecations.oldEscapeTags.warn(event.getScriptEntry());
        if (event.matches("escape")) {
            if (!event.hasValue()) {
                Debug.echoError("Escape tag '" + event.raw_tag + "' does not have a value!");
                return;
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(EscapeTagBase.escape(event.getValue())), event.getAttributes().fulfill(1)));
        }
    }

    public void unEscapeTags(ReplaceableTagEvent event) {
        Deprecations.oldEscapeTags.warn(event.getScriptEntry());
        if (event.matches("unescape")) {
            if (!event.hasValue()) {
                Debug.echoError("Unescape tag '" + event.raw_tag + "' does not have a value!");
                return;
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(EscapeTagBase.unEscape(event.getValue())), event.getAttributes().fulfill(1)));
        }
    }
}

