/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.data;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.data.ActionableDataProvider;
import com.denizenscript.denizencore.utilities.data.DataActionException;
import com.denizenscript.denizencore.utilities.data.DataActionType;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DataAction {
    public ActionableDataProvider provider;
    public DataActionType type;
    public String key;
    public int index = 0;
    public ObjectTag inputValue = null;

    public String debug() {
        return ArgumentHelper.debugObj("action", "(" + this.key + "[" + this.index + "]:" + (Object)((Object)this.type) + ":" + this.inputValue + ")");
    }

    public ListTag autoList(String key) {
        ObjectTag obj = this.provider.getValueAt(key);
        if (obj == null) {
            return new ListTag();
        }
        return this.autoList(ListTag.getListFor(obj));
    }

    public ListTag autoList(ListTag list) {
        return new ListTag(list);
    }

    public ObjectTag autoDup(ObjectTag object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ListTag) {
            return this.autoList((ListTag)object);
        }
        return new ElementTag(object.toString());
    }

    public BigDecimal autoNumber() {
        ObjectTag obj = this.provider.getValueAt(this.key);
        if (this.index != 0) {
            ListTag subList = ListTag.getListFor(obj);
            if (this.index < 0 || this.index > subList.size()) {
                return BigDecimal.ZERO;
            }
            obj = subList.getObject(this.index - 1);
        }
        try {
            return this.autoNumber(obj);
        }
        catch (NumberFormatException ex) {
            return BigDecimal.ZERO;
        }
    }

    public BigDecimal autoNumber(ObjectTag obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(obj.toString());
    }

    public ElementTag autoNumber(BigDecimal decimal) {
        return new ElementTag(decimal);
    }

    public void autoSet(ObjectTag value) {
        if (this.index != 0) {
            ObjectTag obj = this.provider.getValueAt(this.key);
            ListTag subList = ListTag.getListFor(obj);
            subList.setObject(this.index - 1, value);
            value = subList;
        }
        this.provider.setValueAt(this.key, value);
    }

    public void requiresInputValue() {
        if (this.inputValue == null) {
            throw new DataActionException("Input value required for data action " + (Object)((Object)this.type) + ".");
        }
    }

    public void execute() {
        switch (this.type) {
            case INCREMENT: {
                BigDecimal num = this.autoNumber();
                num = num.add(BigDecimal.ONE);
                this.autoSet(this.autoNumber(num));
                break;
            }
            case DECREMENT: {
                BigDecimal num = this.autoNumber();
                num = num.subtract(BigDecimal.ONE);
                this.autoSet(this.autoNumber(num));
                break;
            }
            case ADD: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber();
                num = num.add(this.autoNumber(this.inputValue));
                this.autoSet(this.autoNumber(num));
                break;
            }
            case SUBTRACT: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber();
                num = num.subtract(this.autoNumber(this.inputValue));
                this.autoSet(this.autoNumber(num));
                break;
            }
            case MULTIPLY: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber();
                num = num.multiply(this.autoNumber(this.inputValue));
                this.autoSet(this.autoNumber(num));
                break;
            }
            case DIVIDE: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber();
                num = num.setScale(15, RoundingMode.HALF_UP);
                num = num.divide(this.autoNumber(this.inputValue), RoundingMode.HALF_UP);
                this.autoSet(this.autoNumber(num));
                break;
            }
            case INSERT: {
                this.requiresInputValue();
                ListTag list = this.autoList(this.key);
                list.addObject(this.inputValue);
                this.provider.setValueAt(this.key, list);
                break;
            }
            case REMOVE: {
                ListTag list = this.autoList(this.key);
                if (this.index != 0) {
                    list.remove(this.index - 1);
                }
                this.requiresInputValue();
                String findValue = CoreUtilities.toLowerCase(this.inputValue.toString());
                for (int i = 0; i < list.size(); ++i) {
                    if (!CoreUtilities.toLowerCase((String)list.get(i)).equals(findValue)) continue;
                    list.remove(i);
                    break;
                }
                this.provider.setValueAt(this.key, list);
                break;
            }
            case SPLIT: {
                this.requiresInputValue();
                ListTag list = this.autoList(this.key);
                list.addObjects(ListTag.getListFor((ObjectTag)this.inputValue).objectForms);
                this.provider.setValueAt(this.key, list);
                break;
            }
            case SPLIT_NEW: {
                this.requiresInputValue();
                this.provider.setValueAt(this.key, this.autoList(ListTag.getListFor(this.inputValue)));
                break;
            }
            case SET: {
                this.requiresInputValue();
                this.provider.setValueAt(this.key, this.autoDup(this.inputValue));
                break;
            }
            case AUTO_SET: {
                this.provider.setValueAt(this.key, new ElementTag(true));
                break;
            }
            case CLEAR: {
                this.provider.setValueAt(this.key, null);
            }
        }
    }
}

