/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.debugging;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.core.ConsoleOutputScriptEvent;
import java.io.PrintStream;

public class LogInterceptor
extends PrintStream {
    boolean redirected = false;
    public PrintStream standardOut;
    private boolean antiLoop = false;

    public LogInterceptor() {
        super(System.out, true);
    }

    @Override
    public void print(String s) {
        if (this.antiLoop) {
            super.print(s);
            return;
        }
        this.antiLoop = true;
        ConsoleOutputScriptEvent event = ConsoleOutputScriptEvent.instance;
        event.reset();
        event.message = DenizenCore.getImplementation().cleanseLogString(s);
        event.fire();
        if (!event.cancelled) {
            super.print(s);
        }
        this.antiLoop = false;
    }

    public void redirectOutput() {
        if (this.redirected) {
            return;
        }
        this.standardOut = System.out;
        System.setOut(this);
    }

    public void standardOutput() {
        if (!this.redirected) {
            return;
        }
        System.setOut(this.standardOut);
    }
}

