/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public abstract class BukkitScriptEvent
extends ScriptEvent {
    private static Field REGISTERED_LISTENER_EXECUTOR_FIELD;
    public HashMap<EventPriority, BukkitScriptEvent> priorityHandlers;
    public List<Map.Entry<RegisteredListener, HandlerList>> registeredHandlers;
    public static TagContext noDebugTagContext;

    public boolean couldMatchItem(String text) {
        if (text.equals("item")) {
            return true;
        }
        if (MaterialTag.matches(text) || ItemTag.matches(text)) {
            return true;
        }
        if (text.contains("*")) {
            return true;
        }
        if (text.startsWith("regex:")) {
            return true;
        }
        if (text.contains("|")) {
            for (String subMatch : text.split("\\|")) {
                if (this.couldMatchItem(subMatch)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Class<? extends Event> getRegistrationClass(Class<? extends Event> clazz) {
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException var3) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return BukkitScriptEvent.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
    }

    public static HandlerList getEventListeners(Class<? extends Event> type) {
        try {
            Method method = BukkitScriptEvent.getRegistrationClass(type).getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (Exception var3) {
            throw new IllegalPluginAccessException(var3.toString());
        }
    }

    public static EventExecutor getExecutor(RegisteredListener listener) {
        try {
            return (EventExecutor)REGISTERED_LISTENER_EXECUTOR_FIELD.get(listener);
        }
        catch (IllegalAccessException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public void fire(Event event) {
        if (event instanceof Cancellable) {
            Cancellable cancellable = (Cancellable)event;
            boolean wasCancelled = this.cancelled = cancellable.isCancelled();
            this.fire();
            if (this.cancelled != wasCancelled) {
                cancellable.setCancelled(this.cancelled);
            }
        } else {
            this.cancelled = false;
            this.fire();
        }
    }

    @Override
    public void destroy() {
        if (this.priorityHandlers != null) {
            for (BukkitScriptEvent bukkitScriptEvent : this.priorityHandlers.values()) {
                bukkitScriptEvent.destroy();
            }
            this.priorityHandlers = null;
        }
        if (this.registeredHandlers != null) {
            for (Map.Entry entry : this.registeredHandlers) {
                ((HandlerList)entry.getValue()).unregister((RegisteredListener)entry.getKey());
            }
            this.registeredHandlers = null;
        }
    }

    @Override
    public void init() {
        if (this instanceof Listener) {
            this.initListener((Listener)this);
        }
    }

    public void initListener(Listener listener) {
        if (this.priorityHandlers == null) {
            this.priorityHandlers = new HashMap();
        }
        for (ScriptEvent.ScriptPath path : new ArrayList(this.eventPaths)) {
            String bukkitPriority = path.switches.get("bukkit_priority");
            if (bukkitPriority == null) continue;
            try {
                EventPriority priority = EventPriority.valueOf((String)bukkitPriority.toUpperCase());
                BukkitScriptEvent handler = this.priorityHandlers.get(priority);
                if (handler == null) {
                    handler = (BukkitScriptEvent)this.clone();
                    handler.eventPaths = new ArrayList();
                    handler.priorityHandlers = null;
                    handler.registeredHandlers = null;
                    this.priorityHandlers.put(priority, handler);
                    handler.initForPriority(priority, (Listener)handler);
                }
                handler.eventPaths.add(path);
                this.eventPaths.remove(path);
            }
            catch (IllegalArgumentException ex) {
                Debug.echoError("Invalid 'bukkit_priority' switch for event '" + path.event + "' in script '" + path.container.getName() + "'.");
                Debug.echoError(ex);
            }
        }
        if (!this.eventPaths.isEmpty()) {
            this.initForPriority(EventPriority.NORMAL, listener);
        }
    }

    public void initForPriority(EventPriority priority, Listener listener) {
        if (this.registeredHandlers == null) {
            this.registeredHandlers = new ArrayList<Map.Entry<RegisteredListener, HandlerList>>();
        }
        Denizen plugin = DenizenAPI.getCurrentInstance();
        for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners(listener, (Plugin)plugin).entrySet()) {
            for (RegisteredListener registeredListener : (Set)entry.getValue()) {
                RegisteredListener newListener = new RegisteredListener(listener, BukkitScriptEvent.getExecutor(registeredListener), priority, (Plugin)plugin, false);
                HandlerList handlers = BukkitScriptEvent.getEventListeners(BukkitScriptEvent.getRegistrationClass((Class)entry.getKey()));
                handlers.register(newListener);
                this.registeredHandlers.add(new AbstractMap.SimpleEntry<RegisteredListener, HandlerList>(newListener, handlers));
            }
        }
    }

    @Deprecated
    public boolean runInCheck(ScriptContainer scriptContainer, String s, String lower, Location location) {
        return this.runInCheck(scriptContainer, s, lower, location, "in");
    }

    @Deprecated
    public boolean runInCheck(ScriptContainer scriptContainer, String s, String lower, Location location, String innote) {
        return this.runInCheck(new ScriptEvent.ScriptPath(scriptContainer, s), location, innote);
    }

    public boolean runInCheck(ScriptEvent.ScriptPath path, Location location) {
        return this.runInCheck(path, location, "in");
    }

    public boolean runInCheck(ScriptEvent.ScriptPath path, Location location, String innote) {
        String lower;
        if (location == null) {
            return false;
        }
        String it = path.switches.get(innote);
        if (it == null) {
            int index;
            for (index = 0; index < path.eventArgsLower.length && !path.eventArgsLower[index].equals(innote); ++index) {
            }
            if (index >= path.eventArgsLower.length) {
                return true;
            }
            it = path.eventArgLowerAt(index + 1);
            if (it.equals("notable")) {
                String subit = path.eventArgLowerAt(index + 2);
                if (subit.equals("cuboid")) {
                    return CuboidTag.getNotableCuboidsContaining(location).size() > 0;
                }
                if (subit.equals("ellipsoid")) {
                    return EllipsoidTag.getNotableEllipsoidsContaining(location).size() > 0;
                }
                Debug.echoError("Invalid event 'IN ...' check [" + this.getName() + "] ('in notable ???'): '" + path.event + "' for " + path.container.getName());
                return false;
            }
        }
        if ((lower = CoreUtilities.toLowerCase(it)).equals("cuboid")) {
            return CuboidTag.getNotableCuboidsContaining(location).size() > 0;
        }
        if (lower.equals("ellipsoid")) {
            return EllipsoidTag.getNotableEllipsoidsContaining(location).size() > 0;
        }
        if (WorldTag.matches(it)) {
            return CoreUtilities.toLowerCase(location.getWorld().getName()).equals(lower);
        }
        if (CuboidTag.matches(it)) {
            CuboidTag cuboid = CuboidTag.valueOf(it);
            return cuboid.isInsideCuboid(location);
        }
        if (EllipsoidTag.matches(it)) {
            EllipsoidTag ellipsoid = EllipsoidTag.valueOf(it);
            return ellipsoid.contains(location);
        }
        Debug.echoError("Invalid event 'in:<area>' switch [" + this.getName() + "] ('in:???'): '" + path.event + "' for " + path.container.getName());
        return false;
    }

    public boolean tryLocation(LocationTag location, String comparedto) {
        if (comparedto == null || comparedto.length() == 0) {
            Debug.echoError("Null or empty location string to compare");
            return false;
        }
        if (comparedto.equals("notable")) {
            return true;
        }
        comparedto = "l@" + comparedto;
        LocationTag loc = LocationTag.valueOf(comparedto);
        if (loc == null) {
            Debug.echoError("Invalid location in location comparison string: " + comparedto);
            return false;
        }
        return loc.getBlock().equals(location.getBlock());
    }

    @Deprecated
    public boolean runWithCheck(ScriptContainer scriptContainer, String s, String lower, ItemTag held) {
        return this.runWithCheck(new ScriptEvent.ScriptPath(scriptContainer, s), held);
    }

    public boolean runGenericCheck(String inputValue, String trueValue) {
        if (inputValue != null) {
            trueValue = CoreUtilities.toLowerCase(trueValue);
            if ((inputValue = CoreUtilities.toLowerCase(inputValue)).equalsIgnoreCase(trueValue)) {
                return true;
            }
            Pattern regexd = BukkitScriptEvent.regexHandle(inputValue);
            if (!BukkitScriptEvent.equalityCheck(trueValue, inputValue, regexd)) {
                return false;
            }
        }
        return true;
    }

    public boolean runGenericSwitchCheck(ScriptEvent.ScriptPath path, String switchName, String value) {
        String with = path.switches.get(switchName);
        if (with != null) {
            value = CoreUtilities.toLowerCase(value);
            if ((with = CoreUtilities.toLowerCase(with)).equalsIgnoreCase(value)) {
                return true;
            }
            Pattern regexd = BukkitScriptEvent.regexHandle(with);
            if (!BukkitScriptEvent.equalityCheck(value, with, regexd)) {
                return false;
            }
        }
        return true;
    }

    public boolean runWithCheck(ScriptEvent.ScriptPath path, ItemTag held) {
        String with = path.switches.get("with");
        if (with != null) {
            if (with.equalsIgnoreCase("item")) {
                return true;
            }
            if (held == null || !this.tryItem(held, with)) {
                return false;
            }
        }
        return true;
    }

    public boolean tryInventory(InventoryTag inv, String comparedto) {
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("inventory")) {
            return true;
        }
        if (comparedto.equals("notable")) {
            return NotableManager.isSaved(inv);
        }
        Pattern regexd = BukkitScriptEvent.regexHandle(comparedto);
        if (BukkitScriptEvent.equalityCheck(inv.getInventoryType().name(), comparedto, regexd)) {
            return true;
        }
        if (BukkitScriptEvent.equalityCheck(inv.getIdType(), comparedto, regexd)) {
            return true;
        }
        if (BukkitScriptEvent.equalityCheck(inv.getIdHolder(), comparedto, regexd)) {
            return true;
        }
        if (inv.scriptName != null && BukkitScriptEvent.equalityCheck(inv.scriptName, comparedto, regexd)) {
            return true;
        }
        return NotableManager.isSaved(inv) && BukkitScriptEvent.equalityCheck(NotableManager.getSavedId(inv), comparedto, regexd);
    }

    public boolean tryItem(ItemTag item, String comparedto) {
        if (comparedto == null || comparedto.isEmpty() || item == null) {
            return false;
        }
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("item")) {
            return true;
        }
        if (comparedto.equals("potion") && CoreUtilities.toLowerCase(item.getItemStack().getType().name()).contains("potion")) {
            return true;
        }
        MaterialTag quickOf = MaterialTag.quickOfNamed(comparedto);
        if (quickOf != null) {
            MaterialTag mat = item.getMaterial();
            if (quickOf.getMaterial() != mat.getMaterial()) {
                return false;
            }
            if (quickOf.equals(mat)) {
                return true;
            }
        }
        Pattern regexd = BukkitScriptEvent.regexHandle(comparedto);
        item = new ItemTag(item.getItemStack().clone());
        item.setAmount(1);
        if (BukkitScriptEvent.equalityCheck(item.identify().substring("i@".length()), comparedto, regexd)) {
            return true;
        }
        if (BukkitScriptEvent.equalityCheck(item.identifyMaterialNoIdentifier(), comparedto, regexd)) {
            return true;
        }
        if (BukkitScriptEvent.equalityCheck(item.identifySimple().substring("i@".length()), comparedto, regexd)) {
            return true;
        }
        item.setDurability((short)0);
        return BukkitScriptEvent.equalityCheck(item.identifyMaterialNoIdentifier(), comparedto, regexd);
    }

    public boolean tryMaterial(MaterialTag mat, String comparedto) {
        if (comparedto == null || comparedto.isEmpty() || mat == null) {
            return false;
        }
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("block") || comparedto.equals("material")) {
            return true;
        }
        MaterialTag quickOf = MaterialTag.quickOfNamed(comparedto);
        if (quickOf != null) {
            if (quickOf.getMaterial() != mat.getMaterial()) {
                return false;
            }
            if (quickOf.equals(mat)) {
                return true;
            }
        }
        Pattern regexd = BukkitScriptEvent.regexHandle(comparedto);
        if (BukkitScriptEvent.equalityCheck(mat.realName(), comparedto, regexd)) {
            return true;
        }
        if (BukkitScriptEvent.equalityCheck(mat.identifyNoIdentifier(), comparedto, regexd)) {
            return true;
        }
        if (BukkitScriptEvent.equalityCheck(mat.identifySimpleNoIdentifier(), comparedto, regexd)) {
            return true;
        }
        return BukkitScriptEvent.equalityCheck(mat.identifyFullNoIdentifier(), comparedto, regexd);
    }

    public boolean tryEntity(EntityTag entity, String comparedto) {
        if (comparedto == null || comparedto.isEmpty() || entity == null) {
            return false;
        }
        Entity bEntity = entity.getBukkitEntity();
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("entity")) {
            return true;
        }
        if (comparedto.equals("npc")) {
            return entity.isCitizensNPC();
        }
        if (comparedto.equals("player")) {
            return entity.isPlayer();
        }
        if (comparedto.equals("vehicle")) {
            return bEntity instanceof Vehicle;
        }
        if (comparedto.equals("fish")) {
            return bEntity instanceof Fish;
        }
        if (comparedto.equals("projectile")) {
            return bEntity instanceof Projectile;
        }
        if (comparedto.equals("hanging")) {
            return bEntity instanceof Hanging;
        }
        Pattern regexd = BukkitScriptEvent.regexHandle(comparedto);
        if (entity.getEntityScript() != null && BukkitScriptEvent.equalityCheck(entity.getEntityScript(), comparedto, regexd)) {
            return true;
        }
        return BukkitScriptEvent.equalityCheck(entity.getEntityType().getLowercaseName(), comparedto, regexd);
    }

    static {
        try {
            REGISTERED_LISTENER_EXECUTOR_FIELD = RegisteredListener.class.getDeclaredField("executor");
            REGISTERED_LISTENER_EXECUTOR_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            Debug.echoError(ex);
        }
        noDebugTagContext = new BukkitTagContext(null, null, false, null, false, null);
    }
}

