/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.core;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.OldSmartEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;

public class CuboidEnterExitSmartEvent
implements OldSmartEvent,
Listener {
    ArrayList<String> cuboids_to_watch = new ArrayList();
    private boolean broad_detection = false;
    private Map<String, List<CuboidTag>> player_cuboids = new ConcurrentHashMap<String, List<CuboidTag>>();

    @Override
    public boolean shouldInitialize(Set<String> events) {
        boolean should_register = false;
        this.cuboids_to_watch.clear();
        for (String event : events) {
            Matcher m = Pattern.compile("on player (?:enters|exits) (notable cuboid|(cu@)?\\w+)", 2).matcher(event);
            if (!m.matches()) continue;
            boolean registerable = true;
            if (m.group(1).equalsIgnoreCase("notable cuboid")) {
                this.broad_detection = true;
            } else {
                this.cuboids_to_watch.add(CoreUtilities.toLowerCase(m.group(1)));
            }
            should_register = true;
        }
        return should_register;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        Debug.log("Loaded Cuboid Enter & Exit SmartEvent.");
    }

    @Override
    public void breakDown() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)this);
        PlayerTeleportEvent.getHandlerList().unregister((Listener)this);
        PlayerChangedWorldEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        PlayerMoveEvent evt = new PlayerMoveEvent(event.getPlayer(), event.getFrom(), event.getTo());
        this.internalRun(evt, "teleport");
        if (evt.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        double pos = 1.0E7;
        PlayerMoveEvent pme = new PlayerMoveEvent(event.getPlayer(), event.getPlayer().getLocation(), new Location(event.getPlayer().getWorld(), pos, pos, pos));
        this.internalRun(pme, "leave");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        double pos = 1.0E7;
        PlayerMoveEvent pme = new PlayerMoveEvent(event.getPlayer(), new Location(event.getPlayer().getWorld(), pos, pos, pos), event.getPlayer().getLocation());
        this.internalRun(pme, "join");
    }

    public void onWorldChange(PlayerChangedWorldEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Location to = event.getPlayer().getLocation().clone();
        Location from = event.getPlayer().getLocation().clone();
        from.setWorld(event.getFrom());
        PlayerMoveEvent evt = new PlayerMoveEvent(event.getPlayer(), from, to);
        this.internalRun(evt, "world_change");
    }

    @EventHandler
    public void vehicleMoveEvent(VehicleMoveEvent event) {
        for (Entity entity : event.getVehicle().getPassengers()) {
            if (!EntityTag.isPlayer(entity)) continue;
            PlayerMoveEvent evt = new PlayerMoveEvent((Player)entity, event.getFrom(), event.getTo());
            this.internalRun(evt, "vehicle");
        }
    }

    @EventHandler
    public void playerMoveEvent(PlayerMoveEvent event) {
        this.internalRun(event, "walk");
    }

    public void internalRun(PlayerMoveEvent event, String cause) {
        Object cuboid_context;
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        List<CuboidTag> cuboids = CuboidTag.getNotableCuboidsContaining(event.getTo());
        List<Object> match = new ArrayList();
        String namelow = CoreUtilities.toLowerCase(event.getPlayer().getName());
        if (this.player_cuboids.containsKey(namelow)) {
            match = this.player_cuboids.get(namelow);
        }
        ArrayList exits = new ArrayList(match);
        exits.removeAll(cuboids);
        ArrayList<CuboidTag> enters = new ArrayList<CuboidTag>(cuboids);
        enters.removeAll(match);
        if (exits.isEmpty() && enters.isEmpty()) {
            return;
        }
        if (!exits.isEmpty()) {
            if (this.broad_detection) {
                cuboid_context = new ListTag();
                for (CuboidTag cuboid : exits) {
                    ((ListTag)cuboid_context).add(cuboid.identify());
                }
                if (this.Fire(event, (ListTag)cuboid_context, "player exits notable cuboid", cause)) {
                    return;
                }
            }
            for (CuboidTag cuboidTag : exits) {
                if (!this.Fire(event, new ListTag(cuboidTag.identify()), "player exits " + cuboidTag.identifySimple(), cause)) continue;
                return;
            }
        }
        if (!enters.isEmpty()) {
            if (this.broad_detection) {
                cuboid_context = new ListTag();
                for (CuboidTag cuboid : enters) {
                    ((ListTag)cuboid_context).add(cuboid.identify());
                }
                if (this.Fire(event, (ListTag)cuboid_context, "player enters notable cuboid", cause)) {
                    return;
                }
            }
            for (CuboidTag cuboidTag : enters) {
                if (!this.Fire(event, new ListTag(cuboidTag.identify()), "player enters " + cuboidTag.identifySimple(), cause)) continue;
                return;
            }
        }
        this.player_cuboids.put(namelow, cuboids);
    }

    private boolean Fire(PlayerMoveEvent event, ListTag cuboids, String EventName, String cause) {
        ArrayList<String> events = new ArrayList<String>();
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        context.put("from", new LocationTag(event.getFrom()));
        context.put("to", new LocationTag(event.getTo()));
        context.put("cuboids", cuboids);
        context.put("cause", new ElementTag(cause));
        events.add(EventName);
        String determination = BukkitWorldScriptHelper.doEvents(events, null, EntityTag.getPlayerFrom((Entity)event.getPlayer()), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }
}

