/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.WeatherChangeEvent;

public class WeatherChangesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static WeatherChangesScriptEvent instance;
    public WorldTag world;
    public ElementTag weather;
    public WeatherChangeEvent event;

    public WeatherChangesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventArgLowerAt(0).equals("weather");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (!cmd.equals("changes") && !cmd.equals(this.weather.asString())) {
            return false;
        }
        return this.runGenericCheck(path.eventArgLowerAt(3), this.world.getName());
    }

    @Override
    public String getName() {
        return "WeatherChanges";
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("world")) {
            return this.world;
        }
        if (name.equals("weather")) {
            return this.weather;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onWeatherChanges(WeatherChangeEvent event) {
        this.world = new WorldTag(event.getWorld());
        this.weather = new ElementTag(event.toWeatherState() ? "rains" : "clears");
        this.event = event;
        this.fire((Event)event);
    }
}

