/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.Settings;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.objects.properties.material.MaterialLeaves;
import com.denizenscript.denizen.objects.properties.material.MaterialSwitchFace;
import com.denizenscript.denizen.scripts.commands.world.SwitchCommand;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.MaterialCompat;
import com.denizenscript.denizen.utilities.PathFinder;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.DirectionalBlocksHelper;
import com.denizenscript.denizen.utilities.blocks.OldMaterialsHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Bed;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Dispenser;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Dropper;
import org.bukkit.block.Furnace;
import org.bukkit.block.Lockable;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Attachable;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class LocationTag
extends Location
implements ObjectTag,
Notable,
Adjustable {
    public String backupWorld;
    private boolean is2D = false;
    private boolean raw = false;
    String prefix = "Location";

    public String getWorldName() {
        if (this.getWorld() != null) {
            return this.getWorld().getName();
        }
        return this.backupWorld;
    }

    public LocationTag clone() {
        return (LocationTag)super.clone();
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    @Note(value="Locations")
    public String getSaveObject() {
        return this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getPitch() + "," + this.getYaw() + "," + this.getWorldName();
    }

    public static String getSaved(LocationTag location) {
        for (LocationTag saved : NotableManager.getAllType(LocationTag.class)) {
            if (saved.getX() != location.getX() || saved.getY() != location.getY() || saved.getZ() != location.getZ() || saved.getYaw() != location.getYaw() || saved.getPitch() != location.getPitch() || (saved.getWorldName() != null || location.getWorldName() != null) && (saved.getWorldName() == null || location.getWorldName() == null || !saved.getWorldName().equals(location.getWorldName()))) continue;
            return NotableManager.getSavedId(saved);
        }
        return null;
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    public static LocationTag valueOf(String string) {
        return LocationTag.valueOf(string, null);
    }

    @Fetchable(value="l")
    public static LocationTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("l@")) {
            string = string.substring(2);
        }
        if (NotableManager.isSaved(string) && NotableManager.isType(string, LocationTag.class)) {
            return (LocationTag)NotableManager.getSavedObject(string);
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() == 2) {
            try {
                return new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 3) {
            try {
                World world = Bukkit.getWorld((String)split.get(2));
                if (world != null) {
                    return new LocationTag(world, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
                }
                if (ArgumentHelper.matchesDouble(split.get(2))) {
                    return new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
                }
                LocationTag output = new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
                output.backupWorld = split.get(2);
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 4) {
            try {
                World world = Bukkit.getWorld((String)split.get(3));
                if (world != null) {
                    return new LocationTag(world, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
                }
                LocationTag output = new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
                output.backupWorld = split.get(3);
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 5) {
            try {
                LocationTag output = new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)), Float.valueOf(split.get(3)).floatValue(), Float.valueOf(split.get(4)).floatValue());
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 6) {
            try {
                World world = Bukkit.getWorld((String)split.get(5));
                if (world != null) {
                    return new LocationTag(world, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)), Float.valueOf(split.get(3)).floatValue(), Float.valueOf(split.get(4)).floatValue());
                }
                LocationTag output = new LocationTag(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)), Float.valueOf(split.get(3)).floatValue(), Float.valueOf(split.get(4)).floatValue());
                output.backupWorld = split.get(5);
                return output;
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (context == null || context.debug) {
            Debug.log("Minor: valueOf LocationTag returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.startsWith("l@")) {
            return true;
        }
        return LocationTag.valueOf(string, new BukkitTagContext(null, null, false, null, false, null)) != null;
    }

    public LocationTag(Location location) {
        super(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public LocationTag(Vector vector) {
        super(null, vector.getX(), vector.getY(), vector.getZ());
    }

    public LocationTag(World world, double x, double y) {
        this(world, x, y, 0.0);
        this.is2D = true;
    }

    public LocationTag(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public LocationTag(World world, double x, double y, double z, float pitch, float yaw) {
        super(world, x, y, z, yaw, pitch);
    }

    public boolean isChunkLoaded() {
        return this.getWorld() != null && this.getWorld().isChunkLoaded(this.getBlockX() >> 4, this.getBlockZ() >> 4);
    }

    public boolean isChunkLoadedSafe() {
        try {
            NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
            boolean bl = this.isChunkLoaded();
            return bl;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Block getBlock() {
        if (this.getWorld() == null) {
            Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
            return null;
        }
        return super.getBlock();
    }

    public Block getBlockForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Block block = null;
                return block;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Block block = null;
                return block;
            }
            Block block = super.getBlock();
            return block;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Material getBlockTypeForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Material material = null;
                return material;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Material material = null;
                return material;
            }
            Material material = super.getBlock().getType();
            return material;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public static BlockState getBlockStateFor(Block block) {
        return block.getState();
    }

    public static BlockState getBlockStateSafe(Block block) {
        NMSHandler.getChunkHelper().changeChunkServerThread(block.getWorld());
        try {
            BlockState blockState = block.getState();
            return blockState;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(block.getWorld());
        }
    }

    public Biome getBiomeForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Biome biome = null;
                return biome;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Biome biome = null;
                return biome;
            }
            Biome biome = super.getBlock().getBiome();
            return biome;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Location getHighestBlockForTag(Attribute attribute) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Location location = null;
                return location;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Location location = null;
                return location;
            }
            Location location = this.getWorld().getHighestBlockAt((Location)this).getLocation();
            return location;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ItemStack> getDropsForTag(Attribute attribute, ItemStack item) {
        NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Collection<ItemStack> collection = null;
                return collection;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Collection<ItemStack> collection = null;
                return collection;
            }
            Collection collection = item == null ? super.getBlock().getDrops() : super.getBlock().getDrops(item);
            return collection;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public BlockState getBlockState() {
        return LocationTag.getBlockStateFor(this.getBlock());
    }

    public BlockState getBlockStateForTag(Attribute attribute) {
        Block block = this.getBlockForTag(attribute);
        if (block == null) {
            return null;
        }
        return LocationTag.getBlockStateSafe(block);
    }

    public LocationTag getBlockLocation() {
        return new LocationTag(this.getWorld(), this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }

    private void setRaw(boolean state) {
        this.raw = state;
    }

    public void setPitch(float pitch) {
        super.setPitch(pitch);
    }

    public void setYaw(float yaw) {
        super.setYaw(yaw);
    }

    public boolean hasInventory() {
        return this.getBlockState() instanceof InventoryHolder;
    }

    public Inventory getBukkitInventory() {
        return this.hasInventory() ? ((InventoryHolder)this.getBlockState()).getInventory() : null;
    }

    public InventoryTag getInventory() {
        return this.hasInventory() ? InventoryTag.mirrorBukkitInventory(this.getBukkitInventory()) : null;
    }

    public BlockFace getSkullBlockFace(int rotation) {
        switch (rotation) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 2: {
                return BlockFace.NORTH_EAST;
            }
            case 3: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH_EAST;
            }
            case 7: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case 8: {
                return BlockFace.SOUTH;
            }
            case 9: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 10: {
                return BlockFace.SOUTH_WEST;
            }
            case 11: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 12: {
                return BlockFace.WEST;
            }
            case 13: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 14: {
                return BlockFace.NORTH_WEST;
            }
            case 15: {
                return BlockFace.NORTH_NORTH_WEST;
            }
        }
        return null;
    }

    public byte getSkullRotation(BlockFace face) {
        switch (face) {
            case NORTH: {
                return 0;
            }
            case NORTH_NORTH_EAST: {
                return 1;
            }
            case NORTH_EAST: {
                return 2;
            }
            case EAST_NORTH_EAST: {
                return 3;
            }
            case EAST: {
                return 4;
            }
            case EAST_SOUTH_EAST: {
                return 5;
            }
            case SOUTH_EAST: {
                return 6;
            }
            case SOUTH_SOUTH_EAST: {
                return 7;
            }
            case SOUTH: {
                return 8;
            }
            case SOUTH_SOUTH_WEST: {
                return 9;
            }
            case SOUTH_WEST: {
                return 10;
            }
            case WEST_SOUTH_WEST: {
                return 11;
            }
            case WEST: {
                return 12;
            }
            case WEST_NORTH_WEST: {
                return 13;
            }
            case NORTH_WEST: {
                return 14;
            }
            case NORTH_NORTH_WEST: {
                return 15;
            }
        }
        return -1;
    }

    public int compare(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null || loc1.equals((Object)loc2)) {
            return 0;
        }
        double dist = this.distanceSquared(loc1) - this.distanceSquared(loc2);
        return dist == 0.0 ? 0 : (dist > 0.0 ? 1 : -1);
    }

    public int hashCode() {
        return (int)(Math.floor(this.getX()) + Math.floor(this.getY()) + Math.floor(this.getZ()));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof LocationTag)) {
            return false;
        }
        LocationTag other = (LocationTag)o;
        if (other.getWorldName() == null && this.getWorldName() != null || this.getWorldName() == null && other.getWorldName() != null || this.getWorldName() != null && other.getWorldName() != null && !this.getWorldName().equalsIgnoreCase(other.getWorldName())) {
            return false;
        }
        return Math.floor(this.getX()) == Math.floor(other.getX()) && Math.floor(this.getY()) == Math.floor(other.getY()) && Math.floor(this.getZ()) == Math.floor(other.getZ());
    }

    @Override
    public String getObjectType() {
        return "Location";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public LocationTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "<Y>" + LocationTag.getSaved(this) + "<GR> (" + this.identifyRaw().replace(",", "<G>,<GR> ") + "<GR>)";
        }
        return "<Y>" + this.identifyRaw().replace(",", "<G>,<Y> ");
    }

    @Override
    public boolean isUnique() {
        return LocationTag.getSaved(this) != null;
    }

    @Override
    public String identify() {
        if (!this.raw && this.isUnique()) {
            return "l@" + LocationTag.getSaved(this);
        }
        return this.identifyRaw();
    }

    @Override
    public String identifySimple() {
        if (this.isUnique()) {
            return "l@" + LocationTag.getSaved(this);
        }
        if (this.getWorldName() == null) {
            return "l@" + this.getBlockX() + "," + this.getBlockY() + (!this.is2D ? "," + this.getBlockZ() : "");
        }
        return "l@" + this.getBlockX() + "," + this.getBlockY() + (!this.is2D ? "," + this.getBlockZ() : "") + "," + this.getWorldName();
    }

    public String identifyRaw() {
        if ((double)this.getYaw() != 0.0 || (double)this.getPitch() != 0.0) {
            return "l@" + CoreUtilities.doubleToString(this.getX()) + "," + CoreUtilities.doubleToString(this.getY()) + "," + CoreUtilities.doubleToString(this.getZ()) + "," + CoreUtilities.doubleToString(this.getPitch()) + "," + CoreUtilities.doubleToString(this.getYaw()) + (this.getWorldName() != null ? "," + this.getWorldName() : "");
        }
        return "l@" + CoreUtilities.doubleToString(this.getX()) + "," + CoreUtilities.doubleToString(this.getY()) + (!this.is2D ? "," + CoreUtilities.doubleToString(this.getZ()) : "") + (this.getWorldName() != null ? "," + this.getWorldName() : "");
    }

    public String toString() {
        return this.identify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(Attribute attribute) {
        Block b;
        BlockFace face;
        LocationTag location;
        LocationTag target;
        BlockState blockState;
        Vector vector;
        LocationTag loc;
        Vector facing;
        if (attribute == null) {
            return null;
        }
        if (attribute.matches("block_facing") && (facing = DirectionalBlocksHelper.getFacing(this.getBlockForTag(attribute))) != null) {
            return new LocationTag(this.getWorld(), facing.getX(), facing.getY(), facing.getZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("above")) {
            return new LocationTag(this.clone().add(0.0, attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0, 0.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("below")) {
            return new LocationTag(this.clone().subtract(0.0, attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0, 0.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("forward_flat")) {
            loc = this.clone();
            loc.setPitch(0.0f);
            Vector vector2 = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(this.clone().add(vector2)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("backward_flat")) {
            loc = this.clone();
            loc.setPitch(0.0f);
            Vector vector3 = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(this.clone().subtract(vector3)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("forward")) {
            vector = this.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(this.clone().add(vector)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("backward")) {
            vector = this.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(this.clone().subtract(vector)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("left")) {
            loc = this.clone();
            loc.setPitch(0.0f);
            Vector vector4 = loc.getDirection().rotateAroundY(1.5707963267948966).multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(this.clone().add(vector4)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("right")) {
            loc = this.clone();
            loc.setPitch(0.0f);
            Vector vector5 = loc.getDirection().rotateAroundY(1.5707963267948966).multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(this.clone().subtract(vector5)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("up")) {
            loc = this.clone();
            loc.setPitch(loc.getPitch() - 90.0f);
            Vector vector6 = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(this.clone().add(vector6)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("down")) {
            loc = this.clone();
            loc.setPitch(loc.getPitch() - 90.0f);
            Vector vector7 = loc.getDirection().multiply(attribute.hasContext(1) ? attribute.getDoubleContext(1) : 1.0);
            return new LocationTag(this.clone().subtract(vector7)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("relative") && attribute.hasContext(1)) {
            LocationTag offsetLoc = LocationTag.valueOf(attribute.getContext(1));
            if (offsetLoc == null) {
                return null;
            }
            LocationTag loc2 = this.clone();
            Vector offset = loc2.getDirection().multiply(offsetLoc.getZ());
            loc2.setPitch(loc2.getPitch() - 90.0f);
            offset = offset.add(loc2.getDirection().multiply(offsetLoc.getY()));
            loc2.setPitch(0.0f);
            offset = offset.add(loc2.getDirection().rotateAroundY(1.5707963267948966).multiply(offsetLoc.getX()));
            return new LocationTag(this.clone().add(offset)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("block")) {
            return new LocationTag(this.getWorld(), this.getBlockX(), this.getBlockY(), this.getBlockZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("center")) {
            return new LocationTag(this.getWorld(), (double)this.getBlockX() + 0.5, (double)this.getBlockY() + 0.5, (double)this.getBlockZ() + 0.5).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("highest")) {
            return new LocationTag(this.getHighestBlockForTag(attribute).add(0.0, -1.0, 0.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("base_color")) {
            DyeColor color;
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Debug.echoError("Base_Color tag no longer relevant: banner types are now distinct materials.");
            }
            return new ElementTag((color = ((Banner)this.getBlockStateForTag(attribute)).getBaseColor()) != null ? color.name() : "BLACK").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_inventory")) {
            return new ElementTag(this.getBlockStateForTag(attribute) instanceof InventoryHolder).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory")) {
            if (!this.isChunkLoadedSafe()) {
                return null;
            }
            InventoryTag obj = ElementTag.handleNull(this.identify() + ".inventory", this.getInventory(), "dInventory", attribute.hasAlternative());
            return obj == null ? null : obj.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("material")) {
            Block block = this.getBlockForTag(attribute);
            if (block == null) {
                return null;
            }
            return new MaterialTag(block).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("patterns")) {
            ListTag list = new ListTag();
            for (Pattern pattern : ((Banner)this.getBlockStateForTag(attribute)).getPatterns()) {
                list.add(pattern.getColor().name() + "/" + pattern.getPattern().name());
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("head_rotation")) {
            return new ElementTag(this.getSkullRotation(((Skull)this.getBlockStateForTag(attribute)).getRotation()) + 1).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("switched")) {
            return new ElementTag(SwitchCommand.switchState(this.getBlockForTag(attribute))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sign_contents")) {
            if (this.getBlockStateForTag(attribute) instanceof Sign) {
                return new ListTag(Arrays.asList(((Sign)this.getBlockStateForTag(attribute)).getLines())).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("spawner_type")) {
            if (this.getBlockStateForTag(attribute) instanceof CreatureSpawner) {
                return new EntityTag(DenizenEntityType.getByName(((CreatureSpawner)this.getBlockStateForTag(attribute)).getSpawnedType().name())).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("lock") && this.getBlockStateForTag(attribute) instanceof Lockable) {
            Lockable lock = (Lockable)this.getBlockStateForTag(attribute);
            return new ElementTag(lock.isLocked() ? lock.getLock() : null).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_locked") && this.getBlockStateForTag(attribute) instanceof Lockable) {
            return new ElementTag(((Lockable)this.getBlockStateForTag(attribute)).isLocked()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_lockable")) {
            return new ElementTag(this.getBlockStateForTag(attribute) instanceof Lockable).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("drops")) {
            ItemStack inputItem = null;
            if (attribute.hasContext(1)) {
                inputItem = ItemTag.valueOf(attribute.getContext(1), attribute.context).getItemStack();
            }
            ListTag list = new ListTag();
            for (ItemStack it : this.getDropsForTag(attribute, inputItem)) {
                list.add(new ItemTag(it).identify());
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flowerpot_contents")) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Debug.echoError("As of Minecraft version 1.13 potted flowers each have their own material, such as POTTED_CACTUS.");
            } else if (this.getBlockTypeForTag(attribute) == Material.FLOWER_POT) {
                MaterialData contents = NMSHandler.getBlockHelper().getFlowerpotContents(this.getBlockForTag(attribute));
                return OldMaterialsHelper.getMaterialFrom(contents.getItemType(), contents.getData()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("skull_type") && (blockState = this.getBlockStateForTag(attribute)) instanceof Skull) {
            String t = ((Skull)blockState).getSkullType().name();
            return new ElementTag(t).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("skull_name") && (blockState = this.getBlockStateForTag(attribute)) instanceof Skull) {
            PlayerProfile profile = NMSHandler.getBlockHelper().getPlayerProfile((Skull)blockState);
            if (profile == null) {
                return null;
            }
            String n = profile.getName();
            if (n == null) {
                n = ((Skull)blockState).getOwningPlayer().getName();
            }
            return new ElementTag(n).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("skull_skin")) {
            blockState = this.getBlockStateForTag(attribute);
            if (blockState instanceof Skull) {
                PlayerProfile profile = NMSHandler.getBlockHelper().getPlayerProfile((Skull)blockState);
                if (profile == null) {
                    return null;
                }
                String name = profile.getName();
                UUID uuid = profile.getUniqueId();
                String texture = profile.getTexture();
                if ((attribute = attribute.fulfill(1)).startsWith("full")) {
                    return new ElementTag((uuid != null ? uuid : name) + (texture != null ? "|" + texture : "")).getAttribute(attribute.fulfill(1));
                }
                return new ElementTag(uuid != null ? uuid.toString() : name).getAttribute(attribute);
            }
            return null;
        }
        if (attribute.startsWith("simple.formatted")) {
            return new ElementTag("X '" + this.getBlockX() + "', Y '" + this.getBlockY() + "', Z '" + this.getBlockZ() + "', in world '" + this.getWorldName() + "'").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("simple")) {
            if (this.getWorldName() == null) {
                return new ElementTag(this.getBlockX() + "," + this.getBlockY() + "," + this.getBlockZ()).getAttribute(attribute.fulfill(1));
            }
            return new ElementTag(this.getBlockX() + "," + this.getBlockY() + "," + this.getBlockZ() + "," + this.getWorldName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("precise_impact_normal")) {
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 200;
            }
            double xzLen = Math.cos((double)(this.getPitch() % 360.0f) * (Math.PI / 180));
            double nx = xzLen * Math.sin((double)(-this.getYaw()) * (Math.PI / 180));
            double ny = Math.sin((double)this.getPitch() * (Math.PI / 180));
            double nz = xzLen * Math.cos((double)this.getYaw() * (Math.PI / 180));
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
                Location location2 = NMSHandler.getEntityHelper().getImpactNormal(this, new Vector(nx, -ny, nz), range);
                if (location2 != null) {
                    String string = new LocationTag(location2).getAttribute(attribute.fulfill(1));
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
            }
        }
        if (attribute.startsWith("precise_cursor_on_block")) {
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 200;
            }
            double xzLen = Math.cos((double)(this.getPitch() % 360.0f) * (Math.PI / 180));
            double nx = xzLen * Math.sin((double)(-this.getYaw()) * (Math.PI / 180));
            double ny = Math.sin((double)this.getPitch() * (Math.PI / 180));
            double nz = xzLen * Math.cos((double)this.getYaw() * (Math.PI / 180));
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
                Location location3 = NMSHandler.getEntityHelper().rayTraceBlock(this, new Vector(nx, -ny, nz), range);
                if (location3 != null) {
                    String string = new LocationTag(location3).getBlockLocation().getAttribute(attribute.fulfill(1));
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
            }
        }
        if (attribute.startsWith("precise_cursor_on")) {
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 200;
            }
            double xzLen = Math.cos((double)(this.getPitch() % 360.0f) * (Math.PI / 180));
            double nx = xzLen * Math.sin((double)(-this.getYaw()) * (Math.PI / 180));
            double ny = Math.sin((double)this.getPitch() * (Math.PI / 180));
            double nz = xzLen * Math.cos((double)this.getYaw() * (Math.PI / 180));
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
                Location location4 = NMSHandler.getEntityHelper().rayTrace(this, new Vector(nx, -ny, nz), range);
                if (location4 != null) {
                    String string = new LocationTag(location4).getAttribute(attribute.fulfill(1));
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
            }
        }
        if (attribute.startsWith("points_between")) {
            target = LocationTag.valueOf(attribute.getContext(1));
            if (target == null) {
                return null;
            }
            attribute = attribute.fulfill(1);
            double rad = 1.0;
            if (attribute.startsWith("distance")) {
                rad = attribute.getDoubleContext(1);
                attribute = attribute.fulfill(1);
            }
            ListTag list = new ListTag();
            Vector rel = target.toVector().subtract(this.toVector());
            double len = rel.length();
            rel = rel.multiply(1.0 / len);
            for (double i = 0.0; i <= len; i += rad) {
                list.add(new LocationTag(this.clone().add(rel.clone().multiply(i))).identify());
            }
            return list.getAttribute(attribute);
        }
        if (attribute.startsWith("facing_blocks")) {
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 100;
            }
            ListTag list = new ListTag();
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
                BlockIterator iterator = new BlockIterator((Location)this, 0.0, range);
                while (iterator.hasNext()) {
                    list.add(new LocationTag(iterator.next().getLocation()).identify());
                }
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("line_of_sight") && attribute.hasContext(1) && (location = LocationTag.valueOf(attribute.getContext(1))) != null) {
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
                String list = new ElementTag(NMSHandler.getEntityHelper().canTrace(this.getWorld(), this.toVector(), location.toVector())).getAttribute(attribute.fulfill(1));
                return list;
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
            }
        }
        if (attribute.startsWith("direction.vector")) {
            double xzLen = Math.cos((double)(this.getPitch() % 360.0f) * (Math.PI / 180));
            double nx = xzLen * Math.sin((double)(-this.getYaw()) * (Math.PI / 180));
            double ny = Math.sin((double)this.getPitch() * (Math.PI / 180));
            double nz = xzLen * Math.cos((double)this.getYaw() * (Math.PI / 180));
            return new LocationTag(this.getWorld(), nx, -ny, nz).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("direction")) {
            if (attribute.hasContext(1) && LocationTag.matches(attribute.getContext(1))) {
                target = LocationTag.valueOf(attribute.getContext(1));
                attribute = attribute.fulfill(1);
                EntityHelper entityHelper = NMSHandler.getEntityHelper();
                if (attribute.startsWith("yaw")) {
                    return new ElementTag(entityHelper.normalizeYaw(entityHelper.getYaw(target.toVector().subtract(this.toVector()).normalize()))).getAttribute(attribute.fulfill(1));
                }
                return new ElementTag(entityHelper.getCardinal(entityHelper.getYaw(target.toVector().subtract(this.toVector()).normalize()))).getAttribute(attribute);
            }
            return new ElementTag(NMSHandler.getEntityHelper().getCardinal(this.getYaw())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("face") && attribute.hasContext(1)) {
            LocationTag two = LocationTag.valueOf(attribute.getContext(1));
            return new LocationTag(NMSHandler.getEntityHelper().faceLocation(this, (Location)two)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("facing") && attribute.hasContext(1)) {
            int degrees = 45;
            int attributePos = 1;
            if (attribute.getAttribute(2).startsWith("degrees") && attribute.hasContext(2)) {
                String context = attribute.getContext(2);
                if (context.contains(",")) {
                    String yaw = context.substring(0, context.indexOf(44));
                    String pitch = context.substring(context.indexOf(44) + 1);
                    degrees = ArgumentHelper.getIntegerFrom(yaw);
                    int pitchDegrees = ArgumentHelper.getIntegerFrom(pitch);
                    if (LocationTag.matches(attribute.getContext(1))) {
                        return new ElementTag(NMSHandler.getEntityHelper().isFacingLocation(this, LocationTag.valueOf(attribute.getContext(1)), degrees, pitchDegrees)).getAttribute(attribute.fulfill(attributePos));
                    }
                    if (EntityTag.matches(attribute.getContext(1))) {
                        return new ElementTag(NMSHandler.getEntityHelper().isFacingLocation(this, EntityTag.valueOf(attribute.getContext(1)).getBukkitEntity().getLocation(), degrees, pitchDegrees)).getAttribute(attribute.fulfill(attributePos));
                    }
                } else {
                    degrees = attribute.getIntContext(2);
                    ++attributePos;
                }
            }
            if (LocationTag.matches(attribute.getContext(1))) {
                return new ElementTag(NMSHandler.getEntityHelper().isFacingLocation(this, (Location)LocationTag.valueOf(attribute.getContext(1)), (float)degrees)).getAttribute(attribute.fulfill(attributePos));
            }
            if (EntityTag.matches(attribute.getContext(1))) {
                return new ElementTag(NMSHandler.getEntityHelper().isFacingLocation(this, EntityTag.valueOf(attribute.getContext(1)).getBukkitEntity().getLocation(), (float)degrees)).getAttribute(attribute.fulfill(attributePos));
            }
        }
        if (attribute.startsWith("pitch")) {
            return new ElementTag(this.getPitch()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("with_pose")) {
            String context = attribute.getContext(1);
            float pitch = 0.0f;
            float yaw = 0.0f;
            if (EntityTag.matches(context)) {
                EntityTag ent = EntityTag.valueOf(context);
                if (ent.isSpawned()) {
                    pitch = ent.getBukkitEntity().getLocation().getPitch();
                    yaw = ent.getBukkitEntity().getLocation().getYaw();
                }
            } else if (context.split(",").length == 2) {
                String[] split = context.split(",");
                pitch = Float.parseFloat(split[0]);
                yaw = Float.parseFloat(split[1]);
            }
            LocationTag loc3 = LocationTag.valueOf(this.identify());
            loc3.setPitch(pitch);
            loc3.setYaw(yaw);
            return loc3.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("yaw.simple")) {
            float yaw = NMSHandler.getEntityHelper().normalizeYaw(this.getYaw());
            if (yaw < 45.0f) {
                return new ElementTag("South").getAttribute(attribute.fulfill(2));
            }
            if (yaw < 135.0f) {
                return new ElementTag("West").getAttribute(attribute.fulfill(2));
            }
            if (yaw < 225.0f) {
                return new ElementTag("North").getAttribute(attribute.fulfill(2));
            }
            if (yaw < 315.0f) {
                return new ElementTag("East").getAttribute(attribute.fulfill(2));
            }
            return new ElementTag("South").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("yaw.raw")) {
            return new ElementTag(this.getYaw()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("yaw")) {
            return new ElementTag(NMSHandler.getEntityHelper().normalizeYaw(this.getYaw())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("rotate_around_x") && attribute.hasContext(1)) {
            double angle = attribute.getDoubleContext(1);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double y = this.getY() * cos - this.getZ() * sin;
            double z = this.getY() * sin + this.getZ() * cos;
            LocationTag location5 = this.clone();
            location5.setY(y);
            location5.setZ(z);
            return new LocationTag(location5).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("rotate_around_y") && attribute.hasContext(1)) {
            double angle = attribute.getDoubleContext(1);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double x = this.getX() * cos + this.getZ() * sin;
            double z = this.getX() * -sin + this.getZ() * cos;
            LocationTag location6 = this.clone();
            location6.setX(x);
            location6.setZ(z);
            return new LocationTag(location6).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("rotate_around_z") && attribute.hasContext(1)) {
            double angle = attribute.getDoubleContext(1);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double x = this.getX() * cos - this.getY() * sin;
            double y = this.getZ() * sin + this.getY() * cos;
            LocationTag location7 = this.clone();
            location7.setX(x);
            location7.setY(y);
            return new LocationTag(location7).getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("find") || attribute.startsWith("nearest")) {
            attribute.fulfill(1);
            if (attribute.startsWith("blocks") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<LocationTag> found = new ArrayList<LocationTag>();
                int radius = ArgumentHelper.matchesInteger(attribute.getContext(2)) ? attribute.getIntContext(2) : 10;
                List<Object> materials = new ArrayList();
                if (attribute.hasContext(1)) {
                    materials = ListTag.valueOf(attribute.getContext(1)).filter(MaterialTag.class, attribute.context);
                }
                if (materials == null) {
                    return null;
                }
                int max = Settings.blockTagsMaxBlocks();
                int index = 0;
                attribute.fulfill(2);
                Location tstart = this.getBlockForTag(attribute).getLocation();
                double tstartY = tstart.getY();
                block37: for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        double newY = (double)y + tstartY;
                        if (newY < 0.0 || newY > 255.0) continue;
                        for (int z = -radius; z <= radius; ++z) {
                            if (++index > max) break block37;
                            if (!Utilities.checkLocation(this, tstart.clone().add((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), (double)radius)) continue;
                            if (!materials.isEmpty()) {
                                for (MaterialTag materialTag : materials) {
                                    if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12) && materialTag.hasData() && materialTag.getData() != 0) {
                                        BlockState bs = new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)).getBlockStateForTag(attribute);
                                        if (bs == null || !materialTag.matchesMaterialData(bs.getData())) continue;
                                        found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                                        continue;
                                    }
                                    if (materialTag.getMaterial() != new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)).getBlockTypeForTag(attribute)) continue;
                                    found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                                }
                                continue;
                            }
                            found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                        }
                    }
                }
                Collections.sort(found, new Comparator<LocationTag>(){

                    @Override
                    public int compare(LocationTag loc1, LocationTag loc2) {
                        return LocationTag.this.compare(loc1, loc2);
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("surface_blocks") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<LocationTag> found = new ArrayList<LocationTag>();
                double radius = ArgumentHelper.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                Iterator<Entity> materials = new ArrayList();
                if (attribute.hasContext(1)) {
                    materials = ListTag.valueOf(attribute.getContext(1)).filter(MaterialTag.class, attribute.context);
                }
                if (materials == null) {
                    return null;
                }
                int max = Settings.blockTagsMaxBlocks();
                int index = 0;
                attribute.fulfill(2);
                LocationTag blockLoc = this.getBlockLocation();
                Location loc4 = blockLoc.clone().add(0.5, 0.5, 0.5);
                block41: for (double x = -radius; x <= radius; x += 1.0) {
                    for (double y = -radius; y <= radius; y += 1.0) {
                        for (double z = -radius; z <= radius; z += 1.0) {
                            if (++index > max) break block41;
                            if (!Utilities.checkLocation(loc4, blockLoc.clone().add(x + 0.5, y + 0.5, z + 0.5), radius)) continue;
                            LocationTag locationTag = new LocationTag(blockLoc.clone().add(x, y, z));
                            if (!materials.isEmpty()) {
                                Iterator iterator = materials.iterator();
                                while (iterator.hasNext()) {
                                    MaterialTag material = (MaterialTag)iterator.next();
                                    if (!material.matchesBlock(locationTag.getBlockForTag(attribute)) || new LocationTag(locationTag.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || new LocationTag(locationTag.clone().add(0.0, 2.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || locationTag.getBlockTypeForTag(attribute) == Material.AIR) continue;
                                    found.add(new LocationTag(blockLoc.clone().add(x + 0.5, y, z + 0.5)));
                                }
                                continue;
                            }
                            if (new LocationTag(locationTag.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || new LocationTag(locationTag.clone().add(0.0, 2.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || locationTag.getBlockTypeForTag(attribute) == Material.AIR) continue;
                            found.add(new LocationTag(blockLoc.clone().add(x + 0.5, y, z + 0.5)));
                        }
                    }
                }
                Collections.sort(found, new Comparator<LocationTag>(){

                    @Override
                    public int compare(LocationTag loc1, LocationTag loc2) {
                        return LocationTag.this.compare(loc1, loc2);
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("players") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<PlayerTag> found = new ArrayList<PlayerTag>();
                double radius = ArgumentHelper.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.isDead() || !Utilities.checkLocation(this, player.getLocation(), radius)) continue;
                    found.add(new PlayerTag(player));
                }
                Collections.sort(found, new Comparator<PlayerTag>(){

                    @Override
                    public int compare(PlayerTag pl1, PlayerTag pl2) {
                        return LocationTag.this.compare(pl1.getLocation(), pl2.getLocation());
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("npcs") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<NPCTag> found = new ArrayList<NPCTag>();
                double radius = ArgumentHelper.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                for (Object npc : CitizensAPI.getNPCRegistry()) {
                    if (!npc.isSpawned() || !Utilities.checkLocation(this.getBlockForTag(attribute).getLocation(), npc.getStoredLocation(), radius)) continue;
                    found.add(new NPCTag((NPC)npc));
                }
                Collections.sort(found, new Comparator<NPCTag>(){

                    @Override
                    public int compare(NPCTag npc1, NPCTag npc2) {
                        return LocationTag.this.compare(npc1.getLocation(), npc2.getLocation());
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("entities") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ListTag ent_list = new ListTag();
                if (attribute.hasContext(1)) {
                    ent_list = ListTag.valueOf(attribute.getContext(1));
                }
                ArrayList<EntityTag> found = new ArrayList<EntityTag>();
                double radius = ArgumentHelper.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                block47: for (Entity entity : new WorldTag(this.getWorld()).getEntitiesForTag()) {
                    if (!Utilities.checkLocation(this, entity.getLocation(), radius)) continue;
                    EntityTag current = new EntityTag(entity);
                    if (!ent_list.isEmpty()) {
                        for (String ent : ent_list) {
                            if (!current.comparedTo(ent)) continue;
                            found.add(current);
                            continue block47;
                        }
                        continue;
                    }
                    found.add(current);
                }
                Collections.sort(found, new Comparator<EntityTag>(){

                    @Override
                    public int compare(EntityTag ent1, EntityTag ent2) {
                        return LocationTag.this.compare(ent1.getLocation(), ent2.getLocation());
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("living_entities") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<EntityTag> found = new ArrayList<EntityTag>();
                double radius = ArgumentHelper.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                for (Entity entity : new WorldTag(this.getWorld()).getEntitiesForTag()) {
                    if (!(entity instanceof LivingEntity) || !Utilities.checkLocation(this, entity.getLocation(), radius)) continue;
                    found.add(new EntityTag(entity));
                }
                Collections.sort(found, new Comparator<EntityTag>(){

                    @Override
                    public int compare(EntityTag ent1, EntityTag ent2) {
                        return LocationTag.this.compare(ent1.getLocation(), ent2.getLocation());
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)found).getAttribute(attribute);
            }
        }
        if (attribute.startsWith("find_path") && attribute.hasContext(1)) {
            LocationTag two = LocationTag.valueOf(attribute.getContext(1));
            if (two == null) {
                return null;
            }
            List<LocationTag> locs = PathFinder.getPath(this, two);
            Iterator<EllipsoidTag> list = new ListTag();
            for (LocationTag loc5 : locs) {
                ((ListTag)((Object)list)).add(loc5.identify());
            }
            return ((ListTag)((Object)list)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("formatted.citizens")) {
            return new ElementTag(this.getX() + ":" + this.getY() + ":" + this.getZ() + ":" + this.getWorldName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("formatted")) {
            return new ElementTag("X '" + this.getX() + "', Y '" + this.getY() + "', Z '" + this.getZ() + "', in world '" + this.getWorldName() + "'").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chunk") || attribute.startsWith("get_chunk")) {
            return new ChunkTag(this).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("raw")) {
            LocationTag rawLocation = new LocationTag(this);
            rawLocation.setRaw(true);
            return rawLocation.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return WorldTag.mirrorBukkitWorld(this.getWorld()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("x")) {
            return new ElementTag(this.getX()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("y")) {
            return new ElementTag(this.getY()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("z")) {
            return new ElementTag(this.getZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("with_x") && attribute.hasContext(1)) {
            LocationTag output = this.clone();
            output.setX(attribute.getDoubleContext(1));
            return output.getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("with_y") && attribute.hasContext(1)) {
            LocationTag output = this.clone();
            output.setY(attribute.getDoubleContext(1));
            return output.getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("with_z") && attribute.hasContext(1)) {
            LocationTag output = this.clone();
            output.setZ(attribute.getDoubleContext(1));
            return output.getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("with_yaw") && attribute.hasContext(1)) {
            LocationTag output = this.clone();
            output.setYaw((float)attribute.getDoubleContext(1));
            return output.getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("with_pitch") && attribute.hasContext(1)) {
            LocationTag output = this.clone();
            output.setPitch((float)attribute.getDoubleContext(1));
            return output.getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("with_world") && attribute.hasContext(1)) {
            LocationTag output = this.clone();
            WorldTag world = WorldTag.valueOf(attribute.getContext(1));
            output.setWorld(world.getWorld());
            return output.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("notable_name")) {
            String notname = NotableManager.getSavedId(this);
            if (notname == null) {
                return null;
            }
            return new ElementTag(notname).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("add") && attribute.hasContext(1)) {
            String[] ints = attribute.getContext(1).replace("l@", "").split(",", 4);
            if (ints.length >= 3) {
                if ((ArgumentHelper.matchesDouble(ints[0]) || ArgumentHelper.matchesInteger(ints[0])) && (ArgumentHelper.matchesDouble(ints[1]) || ArgumentHelper.matchesInteger(ints[1])) && (ArgumentHelper.matchesDouble(ints[2]) || ArgumentHelper.matchesInteger(ints[2]))) {
                    return new LocationTag(this.clone().add(Double.valueOf(ints[0]), Double.valueOf(ints[1]), Double.valueOf(ints[2]))).getAttribute(attribute.fulfill(1));
                }
            } else if (LocationTag.matches(attribute.getContext(1))) {
                return new LocationTag(this.clone().add(LocationTag.valueOf(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("sub") && attribute.hasContext(1)) {
            String[] ints = attribute.getContext(1).replace("l@", "").split(",", 4);
            if (ints.length == 3 || ints.length == 4) {
                if ((ArgumentHelper.matchesDouble(ints[0]) || ArgumentHelper.matchesInteger(ints[0])) && (ArgumentHelper.matchesDouble(ints[1]) || ArgumentHelper.matchesInteger(ints[1])) && (ArgumentHelper.matchesDouble(ints[2]) || ArgumentHelper.matchesInteger(ints[2]))) {
                    return new LocationTag(this.clone().subtract(Double.valueOf(ints[0]), Double.valueOf(ints[1]), Double.valueOf(ints[2]))).getAttribute(attribute.fulfill(1));
                }
            } else if (LocationTag.matches(attribute.getContext(1))) {
                return new LocationTag(this.clone().subtract(LocationTag.valueOf(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("mul") && attribute.hasContext(1)) {
            return new LocationTag(this.clone().multiply(Double.parseDouble(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("div") && attribute.hasContext(1)) {
            return new LocationTag(this.clone().multiply(1.0 / Double.parseDouble(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("normalize")) {
            double len = Math.sqrt(Math.pow(this.getX(), 2.0) + Math.pow(this.getY(), 2.0) + Math.pow(this.getZ(), 2.0));
            if (len == 0.0) {
                return this.getAttribute(attribute.fulfill(1));
            }
            return new LocationTag(this.clone().multiply(1.0 / len)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("vector_length")) {
            return new ElementTag(Math.sqrt(Math.pow(this.getX(), 2.0) + Math.pow(this.getY(), 2.0) + Math.pow(this.getZ(), 2.0))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("vector_to_face") && (face = Utilities.faceFor(this.toVector())) != null) {
            return new ElementTag(face.name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("distance_squared") && attribute.hasContext(1) && LocationTag.matches(attribute.getContext(1))) {
            LocationTag toLocation = LocationTag.valueOf(attribute.getContext(1));
            if (!this.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Can't measure distance between two different worlds!");
                }
                return null;
            }
            return new ElementTag(this.distanceSquared(toLocation)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("distance") && attribute.hasContext(1) && LocationTag.matches(attribute.getContext(1))) {
            LocationTag toLocation = LocationTag.valueOf(attribute.getContext(1));
            if (attribute.getAttribute(2).startsWith("horizontal")) {
                if (attribute.getAttribute(3).startsWith("multiworld")) {
                    return new ElementTag(Math.sqrt(Math.pow(this.getX() - toLocation.getX(), 2.0) + Math.pow(this.getZ() - toLocation.getZ(), 2.0))).getAttribute(attribute.fulfill(3));
                }
                if (this.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                    return new ElementTag(Math.sqrt(Math.pow(this.getX() - toLocation.getX(), 2.0) + Math.pow(this.getZ() - toLocation.getZ(), 2.0))).getAttribute(attribute.fulfill(2));
                }
            } else if (attribute.getAttribute(2).startsWith("vertical")) {
                if (attribute.getAttribute(3).startsWith("multiworld")) {
                    return new ElementTag(Math.abs(this.getY() - toLocation.getY())).getAttribute(attribute.fulfill(3));
                }
                if (this.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                    return new ElementTag(Math.abs(this.getY() - toLocation.getY())).getAttribute(attribute.fulfill(2));
                }
            }
            if (!this.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Can't measure distance between two different worlds!");
                }
                return null;
            }
            return new ElementTag(this.distance(toLocation)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_within_border")) {
            return new ElementTag(this.getWorld().getWorldBorder().isInside((Location)this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_within") && attribute.hasContext(1)) {
            if (EllipsoidTag.matches(attribute.getContext(1))) {
                EllipsoidTag ellipsoid = EllipsoidTag.valueOf(attribute.getContext(1));
                if (ellipsoid != null) {
                    return new ElementTag(ellipsoid.contains(this)).getAttribute(attribute.fulfill(1));
                }
            } else {
                CuboidTag cuboid = CuboidTag.valueOf(attribute.getContext(1));
                if (cuboid != null) {
                    return new ElementTag(cuboid.isInsideCuboid(this)).getAttribute(attribute.fulfill(1));
                }
            }
        }
        if (attribute.startsWith("biome.formatted")) {
            return new ElementTag(CoreUtilities.toLowerCase(this.getBiomeForTag(attribute).name()).replace('_', ' ')).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("biome")) {
            return new BiomeTag(this.getBiomeForTag(attribute)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("cuboids")) {
            List<CuboidTag> cuboids = CuboidTag.getNotableCuboidsContaining(this);
            ListTag cuboid_list = new ListTag();
            for (CuboidTag cuboid : cuboids) {
                cuboid_list.add(cuboid.identify());
            }
            return cuboid_list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ellipsoids")) {
            List<EllipsoidTag> ellipsoids = EllipsoidTag.getNotableEllipsoidsContaining(this);
            ListTag ellipsoid_list = new ListTag();
            for (EllipsoidTag ellipsoid : ellipsoids) {
                ellipsoid_list.add(ellipsoid.identify());
            }
            return ellipsoid_list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_liquid") && (b = this.getBlockForTag(attribute)) != null) {
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
                String ellipsoid_list = new ElementTag(b.isLiquid()).getAttribute(attribute.fulfill(1));
                return ellipsoid_list;
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
            }
        }
        if ((attribute.startsWith("light.from_blocks") || attribute.startsWith("light.blocks")) && (b = this.getBlockForTag(attribute)) != null) {
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
                String ellipsoid_list = new ElementTag(this.getBlockForTag(attribute).getLightFromBlocks()).getAttribute(attribute.fulfill(2));
                return ellipsoid_list;
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
            }
        }
        if ((attribute.startsWith("light.from_sky") || attribute.startsWith("light.sky")) && (b = this.getBlockForTag(attribute)) != null) {
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
                String ellipsoid_list = new ElementTag(this.getBlockForTag(attribute).getLightFromSky()).getAttribute(attribute.fulfill(2));
                return ellipsoid_list;
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
            }
        }
        if (attribute.startsWith("light") && (b = this.getBlockForTag(attribute)) != null) {
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
                String ellipsoid_list = new ElementTag(this.getBlockForTag(attribute).getLightLevel()).getAttribute(attribute.fulfill(1));
                return ellipsoid_list;
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
            }
        }
        if (attribute.startsWith("power") && (b = this.getBlockForTag(attribute)) != null) {
            try {
                NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
                String ellipsoid_list = new ElementTag(this.getBlockForTag(attribute).getBlockPower()).getAttribute(attribute.fulfill(1));
                return ellipsoid_list;
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
            }
        }
        if (attribute.startsWith("tree_distance")) {
            MaterialTag material = new MaterialTag(this.getBlockForTag(attribute));
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && MaterialLeaves.describes(material)) {
                return new ElementTag(MaterialLeaves.getFrom(material).getDistance()).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("type")) {
            return new ElementTag("Location").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("command_block_name") && this.getBlockStateForTag(attribute) instanceof CommandBlock) {
            return new ElementTag(((CommandBlock)this.getBlockStateForTag(attribute)).getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("command_block") && this.getBlockStateForTag(attribute) instanceof CommandBlock) {
            return new ElementTag(((CommandBlock)this.getBlockStateForTag(attribute)).getCommand()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("furnace_burn_time")) {
            return new ElementTag(((Furnace)this.getBlockStateForTag(attribute)).getBurnTime()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("furnace_cook_time")) {
            return new ElementTag(((Furnace)this.getBlockStateForTag(attribute)).getCookTime()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("attached_to")) {
            face = BlockFace.SELF;
            MaterialTag material = new MaterialTag(this.getBlockForTag(attribute));
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && MaterialSwitchFace.describes(material)) {
                face = MaterialSwitchFace.getFrom(material).getAttachedTo();
            } else {
                MaterialData data = this.getBlockStateForTag(attribute).getData();
                if (data instanceof Attachable) {
                    face = ((Attachable)data).getAttachedFace();
                }
            }
            if (face != BlockFace.SELF) {
                return new LocationTag(this.getBlockForTag(attribute).getRelative(face).getLocation()).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("other_block")) {
            BlockState state = this.getBlockStateForTag(attribute);
            if (state instanceof Chest && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Vector direction = DirectionalBlocksHelper.getFacing(this.getBlockForTag(attribute));
                if (DirectionalBlocksHelper.isLeftHalf(this.getBlockForTag(attribute))) {
                    direction = new Vector(-direction.getZ(), 0.0, direction.getX());
                } else if (DirectionalBlocksHelper.isRightHalf(this.getBlockForTag(attribute))) {
                    direction = new Vector(direction.getZ(), 0.0, -direction.getX());
                } else {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Block is a single-block chest.");
                    }
                    return null;
                }
                return new LocationTag(this.clone().add(direction)).getAttribute(attribute.fulfill(1));
            }
            if (state instanceof Chest) {
                InventoryHolder holder = ((Chest)state).getBlockInventory().getHolder();
                if (holder instanceof DoubleChest) {
                    Location left = ((DoubleChest)holder).getLeftSide().getInventory().getLocation();
                    Location right = ((DoubleChest)holder).getRightSide().getInventory().getLocation();
                    if (left.getBlockX() == this.getBlockX() && left.getBlockY() == this.getBlockY() && left.getBlockZ() == this.getBlockZ()) {
                        return new LocationTag(right).getAttribute(attribute.fulfill(1));
                    }
                    return new LocationTag(left).getAttribute(attribute.fulfill(1));
                }
            } else {
                if (state instanceof Bed && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                    boolean isTop = DirectionalBlocksHelper.isTopHalf(this.getBlockForTag(attribute));
                    BlockFace direction = DirectionalBlocksHelper.getFace(this.getBlockForTag(attribute));
                    if (!isTop) {
                        direction = direction.getOppositeFace();
                    }
                    return new LocationTag(this.clone().add(direction.getDirection())).getAttribute(attribute.fulfill(1));
                }
                if (state.getData() instanceof Door) {
                    if (((Door)state.getData()).isTopHalf()) {
                        return new LocationTag(this.clone().subtract(0.0, 1.0, 0.0)).getAttribute(attribute.fulfill(1));
                    }
                    return new LocationTag(this.clone().add(0.0, 1.0, 0.0)).getAttribute(attribute.fulfill(1));
                }
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Block of type " + this.getBlockTypeForTag(attribute).name() + " isn't supported by other_block.");
                }
                return null;
            }
            if (!attribute.hasAlternative()) {
                Debug.echoError("Block of type " + this.getBlockTypeForTag(attribute).name() + " doesn't have an other block.");
            }
            return null;
        }
        if (attribute.startsWith("custom_name") && this.getBlockStateForTag(attribute) instanceof Nameable) {
            return new ElementTag(((Nameable)this.getBlockStateForTag(attribute)).getCustomName()).getAttribute(attribute.fulfill(1));
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a location!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        boolean generated;
        Furnace furnace;
        CommandBlock block;
        ListTag list;
        BlockState state;
        if (mechanism.matches("data") && mechanism.hasValue()) {
            Deprecations.materialIds.warn(mechanism.context);
            BlockData blockData = NMSHandler.getBlockHelper().getBlockData(this.getBlock().getType(), (byte)mechanism.getValue().asInt());
            blockData.setBlock(this.getBlock(), false);
        }
        if (mechanism.matches("block_facing") && mechanism.requireObject(LocationTag.class)) {
            LocationTag faceVec = mechanism.valueAsType(LocationTag.class);
            DirectionalBlocksHelper.setFacing(this.getBlock(), faceVec.toVector());
        }
        if (mechanism.matches("block_type") && mechanism.requireObject(MaterialTag.class)) {
            MaterialTag mat = mechanism.valueAsType(MaterialTag.class);
            mat.getNmsBlockData().setBlock(this.getBlock(), false);
        }
        if (mechanism.matches("biome") && mechanism.requireObject(BiomeTag.class)) {
            mechanism.valueAsType(BiomeTag.class).getBiome().changeBlockBiome(this);
        }
        if (mechanism.matches("spawner_type") && mechanism.requireObject(EntityTag.class) && this.getBlockState() instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)this.getBlockState();
            spawner.setSpawnedType(mechanism.valueAsType(EntityTag.class).getBukkitEntityType());
            spawner.update();
        }
        if (mechanism.matches("lock") && this.getBlockState() instanceof Lockable) {
            state = this.getBlockState();
            ((Lockable)state).setLock(mechanism.hasValue() ? mechanism.getValue().asString() : null);
            state.update();
        }
        if (mechanism.matches("sign_contents") && this.getBlockState() instanceof Sign) {
            state = (Sign)this.getBlockState();
            for (int i = 0; i < 4; ++i) {
                state.setLine(i, "");
            }
            list = mechanism.valueAsType(ListTag.class);
            if (list.size() > 4) {
                Debug.echoError("Sign can only hold four lines!");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    state.setLine(i, EscapeTagBase.unEscape((String)list.get(i)));
                }
            }
            state.update();
        }
        if (mechanism.matches("skull_skin")) {
            BlockState blockState = this.getBlockState();
            Material material = this.getBlock().getType();
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && material != Material.PLAYER_HEAD && material != Material.PLAYER_WALL_HEAD) {
                Deprecations.skullSkinMaterials.warn(mechanism.context);
            } else if (blockState instanceof Skull) {
                PlayerProfile profile;
                ListTag list2 = mechanism.valueAsType(ListTag.class);
                String idString = (String)list2.get(0);
                String texture = null;
                if (list2.size() > 1) {
                    texture = (String)list2.get(1);
                }
                if (idString.contains("-")) {
                    UUID uuid = UUID.fromString(idString);
                    String name = null;
                    if (list2.size() > 2) {
                        name = (String)list2.get(2);
                    }
                    profile = new PlayerProfile(name, uuid, texture);
                } else {
                    profile = new PlayerProfile(idString, null, texture);
                }
                profile = NMSHandler.getInstance().fillPlayerProfile(profile);
                if (texture != null) {
                    profile.setTexture(texture);
                }
                NMSHandler.getBlockHelper().setPlayerProfile((Skull)blockState, profile);
            } else {
                Debug.echoError("Unable to set skull_skin on block of type " + material.name() + " with state " + blockState.getClass().getCanonicalName());
            }
        }
        if (mechanism.matches("flowerpot_contents") && mechanism.requireObject(MaterialTag.class)) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Deprecations.flowerpotMechanism.warn(mechanism.context);
            } else if (this.getBlock().getType() == Material.FLOWER_POT) {
                MaterialData data = mechanism.valueAsType(MaterialTag.class).getMaterialData();
                NMSHandler.getBlockHelper().setFlowerpotContents(this.getBlock(), data);
            }
        }
        if (mechanism.matches("command_block_name") && this.getBlock().getType() == MaterialCompat.COMMAND_BLOCK) {
            block = (CommandBlock)this.getBlockState();
            block.setName(mechanism.getValue().asString());
            block.update();
        }
        if (mechanism.matches("command_block") && this.getBlock().getType() == MaterialCompat.COMMAND_BLOCK) {
            block = (CommandBlock)this.getBlockState();
            block.setCommand(mechanism.getValue().asString());
            block.update();
        }
        if (mechanism.matches("custom_name") && this.getBlockState() instanceof Nameable) {
            String title = null;
            if (mechanism.hasValue()) {
                title = mechanism.getValue().asString();
            }
            BlockState state2 = this.getBlockState();
            ((Nameable)state2).setCustomName(title);
            state2.update(true);
        }
        if (mechanism.matches("furnace_burn_time") && MaterialCompat.isFurnace(this.getBlock().getType())) {
            furnace = (Furnace)this.getBlockState();
            furnace.setBurnTime((short)mechanism.getValue().asInt());
            furnace.update();
        }
        if (mechanism.matches("furnace_cook_time") && MaterialCompat.isFurnace(this.getBlock().getType())) {
            furnace = (Furnace)this.getBlockState();
            furnace.setCookTime((short)mechanism.getValue().asInt());
            furnace.update();
        }
        if (mechanism.matches("base_color")) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Debug.echoError("Base_Color mechanism no longer relevant: banner types are now distinct materials.");
            }
            Banner banner = (Banner)this.getBlockState();
            banner.setBaseColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            banner.update();
        }
        if (mechanism.matches("patterns")) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            list = mechanism.valueAsType(ListTag.class);
            for (String string : list) {
                try {
                    List<String> split = CoreUtilities.split(string, '/', 2);
                    patterns.add(new Pattern(DyeColor.valueOf((String)split.get(0).toUpperCase()), PatternType.valueOf((String)split.get(1).toUpperCase())));
                }
                catch (Exception e) {
                    Debug.echoError("Could not apply pattern to banner: " + string);
                }
            }
            Banner banner = (Banner)this.getBlockState();
            banner.setPatterns(patterns);
            banner.update();
        }
        if (mechanism.matches("head_rotation") && mechanism.requireInteger()) {
            Skull sk = (Skull)this.getBlockState();
            sk.setRotation(this.getSkullBlockFace(mechanism.getValue().asInt() - 1));
            sk.update();
        }
        if (mechanism.matches("generate_tree") && mechanism.requireEnum(false, (Enum<?>[])TreeType.values()) && !(generated = this.getWorld().generateTree((Location)this, TreeType.valueOf((String)mechanism.getValue().asString().toUpperCase())))) {
            Debug.echoError("Could not generate tree at " + this.identifySimple() + ". Make sure this location can naturally generate a tree!");
        }
        if (mechanism.matches("activate")) {
            BlockState state3 = this.getBlockState();
            if (state3 instanceof Dispenser) {
                ((Dispenser)state3).dispense();
            } else if (state3 instanceof Dropper) {
                ((Dropper)state3).drop();
            }
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

