/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.npc.traits.HealthTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;

public class EntityHealth
implements Property {
    public static final String[] handledTags = new String[]{"health"};
    public static final String[] handledMechs = new String[]{"max_health", "health_data", "health"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).isLivingEntity();
    }

    public static EntityHealth getFrom(ObjectTag entity) {
        if (!EntityHealth.describes(entity)) {
            return null;
        }
        return new EntityHealth((EntityTag)entity);
    }

    private EntityHealth(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return this.entity.getLivingEntity().getHealth() + "/" + this.entity.getLivingEntity().getMaxHealth();
    }

    @Override
    public String getPropertyId() {
        return "health_data";
    }

    public static String getHealthFormatted(EntityTag entity, Attribute attribute) {
        double maxHealth = entity.getLivingEntity().getMaxHealth();
        if (attribute.hasContext(2)) {
            maxHealth = attribute.getIntContext(2);
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 0.1) {
            return new ElementTag("dying").getAttribute(attribute.fulfill(2));
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 0.4) {
            return new ElementTag("seriously wounded").getAttribute(attribute.fulfill(2));
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 0.75) {
            return new ElementTag("injured").getAttribute(attribute.fulfill(2));
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 1.0) {
            return new ElementTag("scraped").getAttribute(attribute.fulfill(2));
        }
        return new ElementTag("healthy").getAttribute(attribute.fulfill(2));
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("health.formatted")) {
            return EntityHealth.getHealthFormatted(this.entity, attribute);
        }
        if (attribute.startsWith("health.max")) {
            return new ElementTag(this.entity.getLivingEntity().getMaxHealth()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.percentage")) {
            double maxHealth = this.entity.getLivingEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            return new ElementTag(this.entity.getLivingEntity().getHealth() / maxHealth * 100.0).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health")) {
            return new ElementTag(this.entity.getLivingEntity().getHealth()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("max_health") && mechanism.requireDouble()) {
            if (this.entity.isCitizensNPC()) {
                if (this.entity.getDenizenNPC().getCitizen().hasTrait(HealthTrait.class)) {
                    ((HealthTrait)this.entity.getDenizenNPC().getCitizen().getTrait(HealthTrait.class)).setMaxhealth(mechanism.getValue().asInt());
                } else {
                    Debug.echoError("NPC doesn't have health trait!");
                }
            } else if (this.entity.isLivingEntity()) {
                this.entity.getLivingEntity().setMaxHealth(mechanism.getValue().asDouble());
            } else {
                Debug.echoError("Entity is not alive!");
            }
        }
        if (mechanism.matches("health_data")) {
            if (this.entity.isLivingEntity()) {
                List<String> values = CoreUtilities.split(mechanism.getValue().asString(), '/');
                this.entity.getLivingEntity().setMaxHealth(Double.valueOf(values.get(1)).doubleValue());
                this.entity.getLivingEntity().setHealth(Double.valueOf(values.get(0)).doubleValue());
            } else {
                Debug.echoError("Entity is not alive!");
            }
        }
        if (mechanism.matches("health") && mechanism.requireDouble()) {
            if (this.entity.isLivingEntity()) {
                this.entity.getLivingEntity().setHealth(mechanism.getValue().asDouble());
            } else {
                Debug.echoError("Entity is not alive!");
            }
        }
    }
}

