/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.MaterialCompat;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import java.util.ArrayList;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Material;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBook
implements Property {
    public static final String[] handledTags = new String[]{"book"};
    public static final String[] handledMechs = new String[]{"book", "book_raw_pages", "book_pages", "book_author", "book_title"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        Material material = ((ItemTag)item).getItemStack().getType();
        return material == Material.WRITTEN_BOOK || material == MaterialCompat.WRITABLE_BOOK;
    }

    public static ItemBook getFrom(ObjectTag _item) {
        if (!ItemBook.describes(_item)) {
            return null;
        }
        return new ItemBook((ItemTag)_item);
    }

    private ItemBook(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("book")) {
            BookMeta bookInfo = (BookMeta)this.item.getItemStack().getItemMeta();
            attribute = attribute.fulfill(1);
            if (this.item.getItemStack().getType() == Material.WRITTEN_BOOK) {
                if (attribute.startsWith("author")) {
                    return new ElementTag(bookInfo.getAuthor()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("title")) {
                    return new ElementTag(bookInfo.getTitle()).getAttribute(attribute.fulfill(1));
                }
            }
            if (attribute.startsWith("page_count")) {
                return new ElementTag(bookInfo.getPageCount()).getAttribute(attribute.fulfill(1));
            }
            if ((attribute.startsWith("page") || attribute.startsWith("get_page")) && attribute.hasContext(1) && ArgumentHelper.matchesInteger(attribute.getContext(1))) {
                return new ElementTag(bookInfo.getPage(attribute.getIntContext(1))).getAttribute(attribute.fulfill(1));
            }
            if ((attribute.startsWith("raw_page") || attribute.startsWith("get_raw_page")) && attribute.hasContext(1) && ArgumentHelper.matchesInteger(attribute.getContext(1))) {
                return new ElementTag(ComponentSerializer.toString((BaseComponent[])bookInfo.spigot().getPage(attribute.getIntContext(1)))).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("pages.escaped")) {
                StringBuilder output = new StringBuilder();
                for (String page : bookInfo.getPages()) {
                    output.append(EscapeTagBase.escape(page)).append("|");
                }
                return new ListTag(output.length() > 0 ? output.substring(0, output.length() - 1) : output.toString()).getAttribute(attribute.fulfill(2));
            }
            if (attribute.startsWith("pages")) {
                return new ListTag(bookInfo.getPages()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("raw_pages")) {
                ListTag output = new ListTag();
                for (BaseComponent[] page : bookInfo.spigot().getPages()) {
                    output.add(ComponentSerializer.toString((BaseComponent[])page));
                }
                return output.getAttribute(attribute.fulfill(1));
            }
            String output = this.getOutputString();
            if (output == null) {
                output = "null";
            }
            return new ElementTag(output).getAttribute(attribute);
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        String output = this.getOutputString();
        if (output.equals("raw_pages")) {
            return null;
        }
        return output;
    }

    public String getOutputString() {
        StringBuilder output = new StringBuilder();
        BookMeta bookInfo = (BookMeta)this.item.getItemStack().getItemMeta();
        if (this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK) && bookInfo.hasAuthor() && bookInfo.hasTitle()) {
            output.append("author|").append(EscapeTagBase.escape(bookInfo.getAuthor())).append("|title|").append(EscapeTagBase.escape(bookInfo.getTitle())).append("|");
        }
        output.append("raw_pages|");
        if (bookInfo.hasPages()) {
            for (BaseComponent[] page : bookInfo.spigot().getPages()) {
                output.append(EscapeTagBase.escape(ComponentSerializer.toString((BaseComponent[])page))).append("|");
            }
        }
        return output.substring(0, output.length() - 1);
    }

    @Override
    public String getPropertyId() {
        return "book";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        ArrayList<Object> newPages;
        ListTag data;
        BookMeta meta;
        if (mechanism.matches("book_raw_pages")) {
            meta = (BookMeta)this.item.getItemStack().getItemMeta();
            data = mechanism.valueAsType(ListTag.class);
            newPages = new ArrayList<Object>();
            for (String str : data) {
                newPages.add(ComponentSerializer.parse((String)EscapeTagBase.unEscape(str)));
            }
            meta.spigot().setPages(newPages);
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
        if (mechanism.matches("book_pages")) {
            meta = (BookMeta)this.item.getItemStack().getItemMeta();
            data = mechanism.valueAsType(ListTag.class);
            newPages = new ArrayList();
            for (String str : data) {
                newPages.add(EscapeTagBase.unEscape(str));
            }
            meta.setPages(newPages);
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
        if (mechanism.matches("book_author")) {
            if (!this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK)) {
                Debug.echoError("Only WRITTEN_BOOK (not WRITABLE_BOOK) can have a title or author!");
            } else {
                meta = (BookMeta)this.item.getItemStack().getItemMeta();
                meta.setAuthor(mechanism.getValue().asString());
                this.item.getItemStack().setItemMeta((ItemMeta)meta);
            }
        }
        if (mechanism.matches("book_title")) {
            if (!this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK)) {
                Debug.echoError("Only WRITTEN_BOOK (not WRITABLE_BOOK) can have a title or author!");
            } else {
                meta = (BookMeta)this.item.getItemStack().getItemMeta();
                meta.setTitle(mechanism.getValue().asString());
                this.item.getItemStack().setItemMeta((ItemMeta)meta);
            }
        }
        if (mechanism.matches("book")) {
            meta = (BookMeta)this.item.getItemStack().getItemMeta();
            data = mechanism.valueAsType(ListTag.class);
            if (data.size() < 2) {
                Debug.echoError("Invalid book input!");
            } else {
                if (data.size() > 4 && ((String)data.get(0)).equalsIgnoreCase("author") && ((String)data.get(2)).equalsIgnoreCase("title")) {
                    if (!this.item.getItemStack().getType().equals((Object)Material.WRITTEN_BOOK)) {
                        Debug.echoError("Only WRITTEN_BOOK (not WRITABLE_BOOK) can have a title or author!");
                    } else {
                        meta.setAuthor(EscapeTagBase.unEscape((String)data.get(1)));
                        meta.setTitle(EscapeTagBase.unEscape((String)data.get(3)));
                        for (int i = 0; i < 4; ++i) {
                            data.remove(0);
                        }
                    }
                }
                if (((String)data.get(0)).equalsIgnoreCase("raw_pages")) {
                    ArrayList<BaseComponent[]> newPages2 = new ArrayList<BaseComponent[]>();
                    for (int i = 1; i < data.size(); ++i) {
                        newPages2.add(ComponentSerializer.parse((String)EscapeTagBase.unEscape((String)data.get(i))));
                    }
                    meta.spigot().setPages(newPages2);
                } else if (((String)data.get(0)).equalsIgnoreCase("pages")) {
                    ArrayList<String> newPages3 = new ArrayList<String>();
                    for (int i = 1; i < data.size(); ++i) {
                        newPages3.add(EscapeTagBase.unEscape((String)data.get(i)));
                    }
                    meta.setPages(newPages3);
                } else {
                    Debug.echoError("Invalid book input!");
                }
                this.item.getItemStack().setItemMeta((ItemMeta)meta);
            }
        }
    }
}

