/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.SittingTrait;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Sittable;

public class SitCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesArgumentType(LocationTag.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Entity entity;
        LocationTag location = (LocationTag)scriptEntry.getObject("location");
        if (Utilities.getEntryNPC(scriptEntry).getEntityType() != EntityType.PLAYER && Utilities.getEntryNPC(scriptEntry).getEntityType() != EntityType.OCELOT && Utilities.getEntryNPC(scriptEntry).getEntityType() != EntityType.WOLF) {
            Debug.echoError(scriptEntry.getResidingQueue(), "...only Player, ocelot, or wolf type NPCs can sit!");
            return;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("npc", Utilities.getEntryNPC(scriptEntry)) + (location != null ? location.debug() : ""));
        }
        if ((entity = Utilities.getEntryNPC(scriptEntry).getEntity()) instanceof Sittable) {
            ((Sittable)entity).setSitting(true);
        } else {
            SittingTrait trait = (SittingTrait)Utilities.getEntryNPC(scriptEntry).getCitizen().getTrait(SittingTrait.class);
            if (!Utilities.getEntryNPC(scriptEntry).getCitizen().hasTrait(SittingTrait.class)) {
                Utilities.getEntryNPC(scriptEntry).getCitizen().addTrait(SittingTrait.class);
                Debug.echoDebug((Debuggable)scriptEntry, "...added sitting trait");
            }
            if (location != null) {
                trait.sit(location);
            } else {
                trait.sit();
            }
        }
    }
}

