/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ScriptBuilder {
    public static char LINE_PREFIX_CHAR = (char)94;

    public static List<ScriptEntry> addObjectToEntries(List<ScriptEntry> scriptEntryList, String key, Object obj) {
        for (ScriptEntry entry : scriptEntryList) {
            entry.addObject(key, obj);
            entry.trackObject(key);
        }
        return scriptEntryList;
    }

    public static String stripLinePrefix(String rawLine) {
        if (!rawLine.startsWith(String.valueOf(LINE_PREFIX_CHAR))) {
            return rawLine;
        }
        int infoEnd = rawLine.indexOf(LINE_PREFIX_CHAR, 1);
        return rawLine.substring(infoEnd + 2);
    }

    public static List<ScriptEntry> buildScriptEntries(List<Object> contents, ScriptContainer parent, ScriptEntryData data) {
        ArrayList<ScriptEntry> scriptCommands = new ArrayList<ScriptEntry>();
        if (contents == null || contents.isEmpty()) {
            if (Debug.showScriptBuilder) {
                Debug.echoError("Building script entries... no entries to build!");
            }
            return null;
        }
        if (Debug.showScriptBuilder) {
            Debug.echoDebug((Debuggable)parent, "Building script entries:");
        }
        for (Object ientry : contents) {
            List inside;
            String entry;
            if (ientry == null) {
                ientry = "null";
            }
            if (ientry instanceof Map) {
                Object key = ((Map)ientry).keySet().toArray()[0];
                entry = key.toString();
                inside = (List)((Map)ientry).get(key);
            } else {
                entry = ientry.toString();
                inside = null;
            }
            int lineNum = 1;
            if (entry.startsWith(String.valueOf(LINE_PREFIX_CHAR))) {
                int infoEnd = entry.indexOf(LINE_PREFIX_CHAR, 1);
                String lineNumStr = entry.substring(1, infoEnd);
                entry = entry.substring(infoEnd + 2);
                lineNum = Integer.valueOf(lineNumStr);
            }
            String[] scriptEntry = entry.split(" ", 2);
            try {
                Object[] args;
                Object[] objectArray = args = scriptEntry.length > 1 ? ArgumentHelper.buildArgs(scriptEntry[1]) : null;
                if (Debug.showScriptBuilder) {
                    Debug.echoDebug((Debuggable)parent, "Adding '" + scriptEntry[0] + "'  Args: " + Arrays.toString(args));
                }
                ScriptEntry newEntry = new ScriptEntry(scriptEntry[0], (String[])args, parent, inside);
                newEntry.internal.lineNumber = lineNum;
                newEntry.internal.originalLine = entry;
                newEntry.entryData.transferDataFrom(data);
                scriptCommands.add(newEntry);
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
        return scriptCommands;
    }
}

