/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Arrays;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;

public class PlayerChangesSignScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerChangesSignScriptEvent instance;
    public LocationTag location;
    public ListTag new_sign;
    public ListTag old_sign;
    public MaterialTag material;
    public ListTag new_text;
    public SignChangeEvent event;

    public PlayerChangesSignScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String sign = CoreUtilities.getXthArg(2, lower);
        return lower.startsWith("player changes") && (sign.equals("sign") || MaterialTag.matches(sign));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(2);
        if (!(mat.equals("sign") || LocationTag.getBlockStateFor(this.event.getBlock()) instanceof Sign || mat.equals(this.material.identifyNoIdentifier()) || mat.equals(this.material.identifyFullNoIdentifier()))) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "PlayerChangesSign";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (determination.length() > 0 && !PlayerChangesSignScriptEvent.isDefaultDetermination(determinationObj)) {
            this.new_text = ListTag.valueOf(determination);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        if (name.equals("new")) {
            return this.new_sign;
        }
        if (name.equals("old")) {
            return this.old_sign;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerChangesSign(SignChangeEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        BlockState state = LocationTag.getBlockStateFor(event.getBlock());
        if (!(state instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)state;
        this.material = new MaterialTag(event.getBlock());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.old_sign = new ListTag(Arrays.asList(sign.getLines()));
        this.new_sign = new ListTag(Arrays.asList(event.getLines()));
        this.new_text = null;
        this.event = event;
        this.fire((Event)event);
        if (this.new_text != null) {
            for (int i = 0; i < 4 && i < this.new_text.size(); ++i) {
                event.setLine(i, EscapeTagBase.unEscape((String)this.new_text.get(i)));
            }
        }
    }
}

