/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;

public class PlayerStatisticIncrementsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerStatisticIncrementsScriptEvent instance;
    public Statistic statistic;
    public Integer previous_value;
    public Integer new_value;
    public MaterialTag material;
    public EntityTag entity;
    public PlayerStatisticIncrementEvent event;

    public PlayerStatisticIncrementsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player statistic");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String stat = path.eventArgLowerAt(2);
        return stat.equals("increments") || stat.equals(CoreUtilities.toLowerCase(this.statistic.toString()));
    }

    @Override
    public String getName() {
        return "PlayerStatisticIncrements";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("statistic")) {
            return new ElementTag(this.statistic.toString());
        }
        if (name.equals("previous_value")) {
            return new ElementTag(this.previous_value);
        }
        if (name.equals("new_value")) {
            return new ElementTag(this.new_value);
        }
        if (name.equals("qualifier")) {
            if (this.statistic.getType() == Statistic.Type.BLOCK || this.statistic.getType() == Statistic.Type.ITEM) {
                return this.material;
            }
            if (this.statistic.getType() == Statistic.Type.ENTITY) {
                return this.entity;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerStatisticIncrements(PlayerStatisticIncrementEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.material = null;
        this.entity = null;
        this.previous_value = null;
        this.statistic = event.getStatistic();
        if (this.statistic.getType() == Statistic.Type.BLOCK || this.statistic.getType() == Statistic.Type.ITEM) {
            this.material = new MaterialTag(event.getMaterial());
        } else if (this.statistic.getType() == Statistic.Type.ENTITY) {
            this.entity = new EntityTag(DenizenEntityType.getByName(event.getEntityType().name()));
        }
        this.previous_value = event.getPreviousValue();
        this.new_value = event.getNewValue();
        this.event = event;
        this.fire((Event)event);
    }
}

