/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.trade;

import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;

public class TradeHasXp
implements Property {
    public static final String[] handledTags = new String[]{"has_xp"};
    public static final String[] handledMechs = new String[]{"has_xp"};
    private TradeTag recipe;

    public static boolean describes(ObjectTag recipe) {
        return recipe instanceof TradeTag;
    }

    public static TradeHasXp getFrom(ObjectTag recipe) {
        if (!TradeHasXp.describes(recipe)) {
            return null;
        }
        return new TradeHasXp((TradeTag)recipe);
    }

    public TradeHasXp(TradeTag recipe) {
        this.recipe = recipe;
    }

    @Override
    public String getPropertyString() {
        if (this.recipe.getRecipe() == null) {
            return null;
        }
        return String.valueOf(this.recipe.getRecipe().hasExperienceReward());
    }

    @Override
    public String getPropertyId() {
        return "has_xp";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_xp")) {
            return new ElementTag(this.recipe.getRecipe().hasExperienceReward()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("has_xp") && mechanism.requireBoolean()) {
            this.recipe.getRecipe().setExperienceReward(mechanism.getValue().asBoolean());
        }
    }
}

