/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.AnimationHelper;
import com.denizenscript.denizen.nms.interfaces.EntityAnimation;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.List;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.EntityEffect;
import org.bukkit.entity.Player;

public class AnimateCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        AnimationHelper animationHelper = NMSHandler.getAnimationHelper();
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
            }
            if (scriptEntry.hasObject("animation") || scriptEntry.hasObject("effect") || scriptEntry.hasObject("nms_animation")) continue;
            if (arg.matchesEnum((Enum<?>[])PlayerAnimation.values())) {
                scriptEntry.addObject("animation", PlayerAnimation.valueOf((String)arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesEnum((Enum<?>[])EntityEffect.values())) {
                scriptEntry.addObject("effect", EntityEffect.valueOf((String)arg.getValue().toUpperCase()));
                continue;
            }
            if (!animationHelper.hasEntityAnimation(arg.getValue())) continue;
            scriptEntry.addObject("nms_animation", arg.getValue());
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("animation") || scriptEntry.hasObject("nms_animation"))) {
            throw new InvalidArgumentsException("Must specify a valid animation!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String nmsAnimation;
        List entities = (List)scriptEntry.getObject("entities");
        PlayerAnimation animation = scriptEntry.hasObject("animation") ? (PlayerAnimation)scriptEntry.getObject("animation") : null;
        EntityEffect effect = scriptEntry.hasObject("effect") ? (EntityEffect)scriptEntry.getObject("effect") : null;
        String string = nmsAnimation = scriptEntry.hasObject("nms_animation") ? (String)scriptEntry.getObject("nms_animation") : null;
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (animation != null ? ArgumentHelper.debugObj("animation", animation.name()) : (effect != null ? ArgumentHelper.debugObj("effect", effect.name()) : ArgumentHelper.debugObj("animation", nmsAnimation))) + ArgumentHelper.debugObj("entities", entities.toString()));
        }
        for (EntityTag entity : entities) {
            if (!entity.isSpawned()) continue;
            try {
                if (animation != null && entity.getBukkitEntity() instanceof Player) {
                    Player player = (Player)entity.getBukkitEntity();
                    animation.play(player);
                    continue;
                }
                if (effect != null) {
                    entity.getBukkitEntity().playEffect(effect);
                    continue;
                }
                EntityAnimation entityAnimation = NMSHandler.getAnimationHelper().getEntityAnimation(nmsAnimation);
                entityAnimation.play(entity.getBukkitEntity());
            }
            catch (Exception e) {
                Debug.echoError(scriptEntry.getResidingQueue(), "Error playing that animation!");
            }
        }
    }
}

