/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class PlayerBreaksBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerBreaksBlockScriptEvent instance;
    public LocationTag location;
    public MaterialTag material;
    public BlockBreakEvent event;

    public PlayerBreaksBlockScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(2).equals("item") || path.eventArgLowerAt(3).equals("held")) {
            return false;
        }
        return path.eventLower.startsWith("player breaks");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(2);
        if (!this.tryMaterial(this.material, mat)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!this.runWithCheck(path, new ItemTag(this.event.getPlayer().getItemInHand()))) {
            return false;
        }
        return !path.eventArgLowerAt(3).equals("with") || this.tryItem(new ItemTag(this.event.getPlayer().getItemInHand()), path.eventArgLowerAt(4));
    }

    @Override
    public String getName() {
        return "PlayerBreaksBlock";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        Block block = this.event.getBlock();
        if (determinationObj instanceof ElementTag) {
            String lower = CoreUtilities.toLowerCase(determination);
            if (lower.equals("nothing")) {
                this.cancelled = true;
                block.setType(Material.AIR);
                return true;
            }
            if (((ElementTag)determinationObj).isInt()) {
                this.event.setExpToDrop(((ElementTag)determinationObj).asInt());
                return true;
            }
        }
        if (Argument.valueOf(determination).matchesArgumentList(ItemTag.class)) {
            this.cancelled = true;
            block.setType(Material.AIR);
            for (ItemTag newItem : ListTag.valueOf(determination).filter(ItemTag.class, path.container)) {
                block.getWorld().dropItemNaturally(block.getLocation(), newItem.getItemStack());
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        if (name.equals("xp")) {
            return new ElementTag(this.event.getExpToDrop());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerBreaksBlock(BlockBreakEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.material = new MaterialTag(event.getBlock());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

