/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class PlayerCraftsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerCraftsItemScriptEvent instance;
    public boolean resultChanged;
    public ItemTag result;
    public ListTag recipe;
    public CraftingInventory inventory;
    public PlayerTag player;

    public PlayerCraftsItemScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.getXthArg(0, lower).equals("player") && CoreUtilities.getXthArg(1, lower).equals("crafts");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String eItem = path.eventArgLowerAt(2);
        return this.tryItem(this.result, eItem);
    }

    @Override
    public String getName() {
        return "PlayerCraftsItem";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ItemTag.matches(determination)) {
            this.result = ItemTag.valueOf(determination, path.container);
            this.resultChanged = true;
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.result;
        }
        if (name.equals("inventory")) {
            return InventoryTag.mirrorBukkitInventory((Inventory)this.inventory);
        }
        if (name.equals("recipe")) {
            return this.recipe;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (EntityTag.isNPC((Entity)humanEntity)) {
            return;
        }
        Recipe eRecipe = event.getRecipe();
        if (eRecipe == null || eRecipe.getResult() == null) {
            return;
        }
        this.inventory = event.getInventory();
        this.result = new ItemTag(eRecipe.getResult());
        this.recipe = new ListTag();
        for (ItemStack itemStack : this.inventory.getMatrix()) {
            if (itemStack != null) {
                this.recipe.add(new ItemTag(itemStack).identify());
                continue;
            }
            this.recipe.add(new ItemTag(Material.AIR).identify());
        }
        this.player = EntityTag.getPlayerFrom((Entity)humanEntity);
        this.resultChanged = false;
        this.cancelled = false;
        this.fire((Event)event);
        if (this.cancelled) {
            event.setCancelled(true);
        } else if (this.resultChanged) {
            event.setCurrentItem(this.result.getItemStack());
        }
    }
}

