/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.utilities.Utilities;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;

public class SleepingTrait
extends Trait {
    @Persist(value="sleeping")
    private boolean sleeping = false;
    @Persist(value="bed location")
    private Location bedLocation = null;

    public void run() {
        if (this.npc == null || this.bedLocation == null) {
            return;
        }
        if (!Utilities.checkLocation((LivingEntity)this.npc.getEntity(), this.bedLocation, 1.0)) {
            this.wakeUp();
        }
    }

    public void toSleep() {
        if (this.sleeping) {
            return;
        }
        PlayerAnimation.SLEEP.play((Player)this.npc.getEntity());
        this.sleeping = true;
        this.bedLocation = this.npc.getEntity().getLocation();
    }

    public void toSleep(Location location) {
        if (this.sleeping) {
            return;
        }
        this.npc.getEntity().teleport(location.add(0.5, 0.0, 0.5));
        PlayerAnimation.SLEEP.play((Player)this.npc.getEntity());
        this.sleeping = true;
        this.bedLocation = location;
    }

    public void wakeUp() {
        if (!this.sleeping) {
            return;
        }
        PlayerAnimation.STOP_SLEEPING.play((Player)this.npc.getEntity());
        this.bedLocation = null;
        this.sleeping = false;
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    public Location getBed() {
        return this.bedLocation;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.bedLocation == null) {
            return;
        }
        if (event.getBlock().getLocation().equals((Object)this.bedLocation)) {
            event.setCancelled(true);
        }
    }

    public SleepingTrait() {
        super("sleeping");
    }
}

