/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.DyeColor;

public class ColorTag
implements ObjectTag {
    static final Pattern rgbPattern = Pattern.compile("(\\d+)[,:](\\d+)[,:](\\d+)");
    private org.bukkit.Color color;
    String prefix = "color";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static ColorTag valueOf(String string) {
        return ColorTag.valueOf(string, null);
    }

    @Fetchable(value="co")
    public static ColorTag valueOf(String string, TagContext context) {
        if ((string = string.toUpperCase().replace("CO@", "")).matches("RANDOM")) {
            return new ColorTag(CoreUtilities.getRandom().nextInt(256), CoreUtilities.getRandom().nextInt(256), CoreUtilities.getRandom().nextInt(256));
        }
        Matcher m = rgbPattern.matcher(string);
        if (m.matches()) {
            return new ColorTag(ArgumentHelper.getIntegerFrom(m.group(1)), ArgumentHelper.getIntegerFrom(m.group(2)), ArgumentHelper.getIntegerFrom(m.group(3)));
        }
        Field colorField = null;
        try {
            colorField = org.bukkit.Color.class.getField(string.toUpperCase());
        }
        catch (SecurityException e1) {
            Debug.echoError("Security exception getting color field!");
        }
        catch (NoSuchFieldException e1) {
            Debug.echoError("No such color field '" + string + "'!");
        }
        if (colorField != null) {
            return new ColorTag(colorField);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if ((arg = arg.toUpperCase().replace("CO@", "")).toUpperCase().matches("RANDOM")) {
            return true;
        }
        Matcher m = rgbPattern.matcher(arg);
        if (m.matches()) {
            return true;
        }
        for (Field field : org.bukkit.Color.class.getFields()) {
            if (!arg.toUpperCase().matches(field.getName())) continue;
            return true;
        }
        return false;
    }

    public ColorTag(int red, int green, int blue) {
        this.color = org.bukkit.Color.fromRGB((int)red, (int)green, (int)blue);
    }

    public ColorTag(Field field) {
        try {
            this.color = (org.bukkit.Color)field.get(null);
        }
        catch (Exception e) {
            Debug.echoError("Exception trying to fetch color!");
        }
    }

    public ColorTag(org.bukkit.Color color) {
        this.color = color;
    }

    public ColorTag(DyeColor dyeColor) {
        this.color = dyeColor.getColor();
    }

    public org.bukkit.Color getColor() {
        return this.color;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "Color";
    }

    @Override
    public String identify() {
        for (Field field : org.bukkit.Color.class.getFields()) {
            try {
                if (!org.bukkit.Color.class.isAssignableFrom(field.getType()) || ((org.bukkit.Color)field.get(null)).asRGB() != this.getColor().asRGB()) continue;
                return "co@" + field.getName();
            }
            catch (Exception e) {
                Debug.echoError("Exception trying to fetch color: " + e.getClass().getCanonicalName() + ": " + e.getMessage());
            }
        }
        return "co@" + this.getColor().getRed() + "," + this.getColor().getGreen() + "," + this.getColor().getBlue();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public static void registerTags() {
        ColorTag.registerTag("red", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ColorTag)object).color.getRed()).getAttribute(attribute.fulfill(1));
            }
        });
        ColorTag.registerTag("green", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ColorTag)object).color.getGreen()).getAttribute(attribute.fulfill(1));
            }
        });
        ColorTag.registerTag("blue", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ColorTag)object).color.getBlue()).getAttribute(attribute.fulfill(1));
            }
        });
        ColorTag.registerTag("rgb", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                org.bukkit.Color color = ((ColorTag)object).color;
                return new ElementTag(color.getRed() + "," + color.getGreen() + "," + color.getBlue()).getAttribute(attribute.fulfill(1));
            }
        });
        ColorTag.registerTag("hue", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ColorTag)object).ToHSB()[0]).getAttribute(attribute.fulfill(1));
            }
        });
        ColorTag.registerTag("saturation", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ColorTag)object).ToHSB()[1]).getAttribute(attribute.fulfill(1));
            }
        });
        ColorTag.registerTag("brightness", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ColorTag)object).ToHSB()[2]).getAttribute(attribute.fulfill(1));
            }
        });
        ColorTag.registerTag("hsv", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                int[] HSV = ((ColorTag)object).ToHSB();
                return new ElementTag(HSV[1] + "," + HSV[1] + "," + HSV[2]).getAttribute(attribute.fulfill(1));
            }
        });
        ColorTag.registerTag("name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(object.identify().substring(3)).getAttribute(attribute.fulfill(1));
            }
        });
        ColorTag.registerTag("mix", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.insert[...] must have a value.");
                    return null;
                }
                ColorTag mixed_with = ColorTag.valueOf(attribute.getContext(1));
                if (mixed_with != null) {
                    return new ColorTag(((ColorTag)object).color.mixColors(new org.bukkit.Color[]{mixed_with.getColor()})).getAttribute(attribute.fulfill(1));
                }
                Debug.echoError("'" + attribute.getContext(1) + "' is not a valid color!");
                return null;
            }
        });
        ColorTag.registerTag("to_particle_offset", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                org.bukkit.Color valid = ((ColorTag)object).color;
                if (valid.asRGB() == 0) {
                    valid = org.bukkit.Color.fromRGB((int)1, (int)0, (int)0);
                }
                return new LocationTag(null, (float)valid.getRed() / 255.0f, (float)valid.getGreen() / 255.0f, (float)valid.getBlue() / 255.0f).getAttribute(attribute.fulfill(1));
            }
        });
        ColorTag.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag("Color").getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                com.denizenscript.denizencore.utilities.debugging.Debug.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }

    int[] ToHSB() {
        float[] base = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
        return new int[]{(int)(base[0] * 255.0f), (int)(base[1] * 255.0f), (int)(base[2] * 255.0f)};
    }
}

