/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class PluginTag
implements ObjectTag {
    private Plugin plugin;
    private String prefix = "Plugin";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static PluginTag valueOf(String string) {
        return PluginTag.valueOf(string, null);
    }

    @Fetchable(value="pl")
    public static PluginTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = CoreUtilities.toLowerCase(string).replace("pl@", "");
        try {
            for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                if (!string.equalsIgnoreCase(plugin.getName())) continue;
                return new PluginTag(plugin);
            }
        }
        catch (Exception e) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Invalid plugin name specified, or plugin is not enabled: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (CoreUtilities.toLowerCase(arg).startsWith("pl@")) {
            return true;
        }
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            if (!arg.equalsIgnoreCase(plugin.getName())) continue;
            return true;
        }
        return false;
    }

    public PluginTag(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getObjectType() {
        return "Plugin";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "pl@" + this.plugin.getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public PluginTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        PluginTag.registerTag("name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PluginTag)object).plugin.getName()).getAttribute(attribute.fulfill(1));
            }
        });
        PluginTag.registerTag("version", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PluginTag)object).plugin.getDescription().getVersion()).getAttribute(attribute.fulfill(1));
            }
        });
        PluginTag.registerTag("description", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PluginTag)object).plugin.getDescription().getDescription()).getAttribute(attribute.fulfill(1));
            }
        });
        PluginTag.registerTag("authors", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ListTag(((PluginTag)object).plugin.getDescription().getAuthors()).getAttribute(attribute.fulfill(1));
            }
        });
        PluginTag.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag("Plugin").getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                Debug.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }
}

