/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;

public class EntityAI
implements Property {
    public static final String[] handledTags = new String[]{"has_ai"};
    public static final String[] handledMechs = new String[]{"has_ai", "toggle_ai"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).isLivingEntity();
    }

    public static EntityAI getFrom(ObjectTag entity) {
        if (!EntityAI.describes(entity)) {
            return null;
        }
        return new EntityAI((EntityTag)entity);
    }

    private EntityAI(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(!NMSHandler.getEntityHelper().isAIDisabled(this.entity.getBukkitEntity()));
    }

    @Override
    public String getPropertyId() {
        return "has_ai";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_ai")) {
            return new ElementTag(!NMSHandler.getEntityHelper().isAIDisabled(this.entity.getBukkitEntity())).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("has_ai") || mechanism.matches("toggle_ai")) && mechanism.requireBoolean()) {
            NMSHandler.getEntityHelper().toggleAI(this.entity.getBukkitEntity(), mechanism.getValue().asBoolean());
        }
    }
}

