/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import java.util.UUID;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;

public class EntityAttributes
implements Property {
    public static final String[] handledTags = new String[]{"has_attribute", "attribute_value", "attribute_base_value", "attribute_default_value", "attributes"};
    public static final String[] handledMechs = new String[]{"attributes"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Attributable;
    }

    public static EntityAttributes getFrom(ObjectTag entity) {
        if (!EntityAttributes.describes(entity)) {
            return null;
        }
        return new EntityAttributes((EntityTag)entity);
    }

    private EntityAttributes(EntityTag entity) {
        this.entity = entity;
    }

    public static String stringify(AttributeModifier modifier) {
        return EscapeTagBase.escape(modifier.getName()) + "/" + modifier.getAmount() + "/" + modifier.getOperation().name() + "/" + (modifier.getSlot() == null ? "any" : modifier.getSlot().name());
    }

    public ListTag getAttributes() {
        ListTag list = new ListTag();
        for (Attribute attribute : Attribute.values()) {
            AttributeInstance instance = ((Attributable)this.entity.getBukkitEntity()).getAttribute(attribute);
            if (instance == null) continue;
            StringBuilder modifiers = new StringBuilder();
            for (AttributeModifier modifier : instance.getModifiers()) {
                modifiers.append("/").append(EntityAttributes.stringify(modifier));
            }
            list.add(EscapeTagBase.escape(attribute.name()) + "/" + instance.getBaseValue() + modifiers.toString());
        }
        return list;
    }

    @Override
    public String getPropertyString() {
        ListTag list = this.getAttributes();
        if (list.size() > 0) {
            return list.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "attributes";
    }

    @Override
    public String getAttribute(com.denizenscript.denizencore.tags.Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("attributes")) {
            return this.getAttributes().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_attribute") && attribute.hasContext(1)) {
            AttributeInstance instance = ((Attributable)this.entity.getBukkitEntity()).getAttribute(Attribute.valueOf((String)attribute.getContext(1).toUpperCase()));
            return new ElementTag(instance != null).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("attribute_value") && attribute.hasContext(1)) {
            Attribute attr = Attribute.valueOf((String)attribute.getContext(1).toUpperCase());
            AttributeInstance instance = ((Attributable)this.entity.getBukkitEntity()).getAttribute(attr);
            if (instance == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntity().getType().name());
                }
                return null;
            }
            return new ElementTag(instance.getValue()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("attribute_base_value") && attribute.hasContext(1)) {
            Attribute attr = Attribute.valueOf((String)attribute.getContext(1).toUpperCase());
            AttributeInstance instance = ((Attributable)this.entity.getBukkitEntity()).getAttribute(attr);
            if (instance == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntity().getType().name());
                }
                return null;
            }
            return new ElementTag(instance.getBaseValue()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("attribute_default_value") && attribute.hasContext(1)) {
            Attribute attr = Attribute.valueOf((String)attribute.getContext(1).toUpperCase());
            AttributeInstance instance = ((Attributable)this.entity.getBukkitEntity()).getAttribute(attr);
            if (instance == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntity().getType().name());
                }
                return null;
            }
            return new ElementTag(instance.getDefaultValue()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("attributes") && mechanism.hasValue()) {
            Attributable ent = (Attributable)this.entity.getBukkitEntity();
            ListTag list = mechanism.valueAsType(ListTag.class);
            for (String str : list) {
                List<String> subList = CoreUtilities.split(str, '/');
                Attribute attr = Attribute.valueOf((String)EscapeTagBase.unEscape(subList.get(0)).toUpperCase());
                AttributeInstance instance = ent.getAttribute(attr);
                if (instance == null) {
                    Debug.echoError("Attribute " + attr.name() + " is not applicable to entity of type " + this.entity.getBukkitEntity().getType().name());
                    continue;
                }
                instance.setBaseValue(ArgumentHelper.getDoubleFrom(subList.get(1)));
                for (AttributeModifier modifier : instance.getModifiers()) {
                    instance.removeModifier(modifier);
                }
                for (int x = 2; x < subList.size(); x += 4) {
                    String slot = subList.get(x + 3).toUpperCase();
                    AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), EscapeTagBase.unEscape(subList.get(x)), ArgumentHelper.getDoubleFrom(subList.get(x + 1)), AttributeModifier.Operation.valueOf((String)subList.get(x + 2).toUpperCase()), slot.equals("ANY") ? null : EquipmentSlot.valueOf((String)slot));
                    instance.addModifier(modifier);
                }
            }
        }
    }
}

