/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.BoundingBox;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class EntityBoundingBox
implements Property {
    public static final String[] handledTags = new String[]{"bounding_box"};
    public static final String[] handledMechs = new String[]{"bounding_box"};
    private static Set<UUID> modifiedBoxes = new HashSet<UUID>();
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        return object instanceof EntityTag;
    }

    public static EntityBoundingBox getFrom(ObjectTag object) {
        if (!EntityBoundingBox.describes(object)) {
            return null;
        }
        return new EntityBoundingBox((EntityTag)object);
    }

    public static void remove(UUID uuid) {
        if (modifiedBoxes.contains(uuid)) {
            modifiedBoxes.remove(uuid);
        }
    }

    private EntityBoundingBox(EntityTag entity) {
        this.entity = entity;
    }

    private ListTag getBoundingBox() {
        BoundingBox boundingBox = NMSHandler.getEntityHelper().getBoundingBox(this.entity.getBukkitEntity());
        ListTag list = new ListTag();
        list.add(new LocationTag(boundingBox.getLow().toLocation(this.entity.getWorld())).identify());
        list.add(new LocationTag(boundingBox.getHigh().toLocation(this.entity.getWorld())).identify());
        return list;
    }

    @Override
    public String getPropertyString() {
        if (this.entity.isCitizensNPC()) {
            return null;
        }
        if (modifiedBoxes.contains(this.entity.getUUID())) {
            return this.getBoundingBox().identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "bounding_box";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("bounding_box")) {
            return this.getBoundingBox().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("bounding_box")) {
            if (this.entity.isCitizensNPC()) {
                return;
            }
            List<LocationTag> locations = mechanism.valueAsType(ListTag.class).filter(LocationTag.class, mechanism.context);
            if (locations.size() == 2) {
                BoundingBox boundingBox = new BoundingBox(locations.get(0).toVector(), locations.get(1).toVector());
                NMSHandler.getEntityHelper().setBoundingBox(this.entity.getBukkitEntity(), boundingBox);
                modifiedBoxes.add(this.entity.getUUID());
            } else {
                Debug.echoError("Must specify exactly 2 LocationTags in the format '<low>|<high>'!");
            }
        }
    }
}

