/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemInventory
implements Property {
    public static final String[] handledTags = new String[]{"inventory"};
    public static final String[] handledMechs = new String[]{"inventory"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)((ItemTag)item).getItemStack().getItemMeta()).getBlockState() instanceof InventoryHolder;
    }

    public static ItemInventory getFrom(ObjectTag _item) {
        if (!ItemInventory.describes(_item)) {
            return null;
        }
        return new ItemInventory((ItemTag)_item);
    }

    private InventoryTag getItemInventory() {
        return InventoryTag.mirrorBukkitInventory(((InventoryHolder)((BlockStateMeta)this.item.getItemStack().getItemMeta()).getBlockState()).getInventory());
    }

    private ItemInventory(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("inventory")) {
            return this.getItemInventory().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        InventoryTag inv = this.getItemInventory();
        return inv != null ? inv.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "inventory";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("inventory") && mechanism.requireObject(InventoryTag.class)) {
            InventoryTag inventory = mechanism.valueAsType(InventoryTag.class);
            if (inventory == null || inventory.getInventory() == null) {
                return;
            }
            ItemStack itemStack = this.item.getItemStack();
            BlockStateMeta bsm = (BlockStateMeta)itemStack.getItemMeta();
            InventoryHolder invHolder = (InventoryHolder)bsm.getBlockState();
            if (inventory.getSize() > invHolder.getInventory().getSize()) {
                Debug.echoError("Invalid InventoryTag size; expected " + invHolder.getInventory().getSize() + " or less.");
                return;
            }
            invHolder.getInventory().setContents(inventory.getContents());
            bsm.setBlockState((BlockState)invHolder);
            itemStack.setItemMeta((ItemMeta)bsm);
        }
    }
}

