/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lockable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemLock
implements Property {
    public static final String[] handledTags = new String[]{"lock", "is_locked"};
    public static final String[] handledMechs = new String[]{"lock"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)((ItemTag)item).getItemStack().getItemMeta()).getBlockState() instanceof Lockable;
    }

    public static ItemLock getFrom(ObjectTag _item) {
        if (!ItemLock.describes(_item)) {
            return null;
        }
        return new ItemLock((ItemTag)_item);
    }

    private String getItemLock() {
        return ((Lockable)((BlockStateMeta)this.item.getItemStack().getItemMeta()).getBlockState()).getLock();
    }

    private boolean isLocked() {
        return ((Lockable)((BlockStateMeta)this.item.getItemStack().getItemMeta()).getBlockState()).isLocked();
    }

    private ItemLock(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("lock")) {
            return new ElementTag(this.isLocked() ? this.getItemLock() : null).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_locked")) {
            return new ElementTag(this.isLocked()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        return this.isLocked() ? this.getItemLock() : null;
    }

    @Override
    public String getPropertyId() {
        return "lock";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("lock")) {
            ItemStack itemStack = this.item.getItemStack();
            BlockStateMeta bsm = (BlockStateMeta)itemStack.getItemMeta();
            Lockable lockable = (Lockable)bsm.getBlockState();
            lockable.setLock(mechanism.hasValue() ? mechanism.getValue().asString() : null);
            bsm.setBlockState((BlockState)lockable);
            itemStack.setItemMeta((ItemMeta)bsm);
        }
    }
}

