/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import java.util.Arrays;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemSignContents
implements Property {
    public static final String[] handledTags = new String[]{"sign_contents"};
    public static final String[] handledMechs = new String[]{"sign_contents"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)((ItemTag)item).getItemStack().getItemMeta()).getBlockState() instanceof Sign;
    }

    public static ItemSignContents getFrom(ObjectTag _item) {
        if (!ItemSignContents.describes(_item)) {
            return null;
        }
        return new ItemSignContents((ItemTag)_item);
    }

    private ListTag getSignContents() {
        return new ListTag(Arrays.asList(((Sign)((BlockStateMeta)this.item.getItemStack().getItemMeta()).getBlockState()).getLines()));
    }

    private ItemSignContents(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("sign_contents")) {
            return this.getSignContents().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        for (String line : this.getSignContents()) {
            if (line.length() <= 0) continue;
            return this.getSignContents().identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "sign_contents";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("sign_contents")) {
            ItemStack itemStack = this.item.getItemStack();
            BlockStateMeta bsm = (BlockStateMeta)itemStack.getItemMeta();
            Sign sign = (Sign)bsm.getBlockState();
            for (int i = 0; i < 4; ++i) {
                sign.setLine(i, "");
            }
            ListTag list = mechanism.valueAsType(ListTag.class);
            if (list.size() > 4) {
                Debug.echoError("Sign can only hold four lines!");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    sign.setLine(i, EscapeTagBase.unEscape((String)list.get(i)));
                }
            }
            bsm.setBlockState((BlockState)sign);
            itemStack.setItemMeta((ItemMeta)bsm);
        }
    }
}

