/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.trait.LookClose;

public class LookcloseCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matches("realistic", "realistically")) {
                scriptEntry.addObject("realistic", new ElementTag(true));
                continue;
            }
            if (arg.matchesPrimitive(ArgumentHelper.PrimitiveType.Integer)) {
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (arg.matchesPrimitive(ArgumentHelper.PrimitiveType.Boolean)) {
                scriptEntry.addObject("toggle", arg.asElement());
                continue;
            }
            if (arg.matchesArgumentType(NPCTag.class)) {
                ((BukkitScriptEntryData)scriptEntry.entryData).setNPC(arg.asType(NPCTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (Utilities.getEntryNPC(scriptEntry) == null) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), Utilities.getEntryNPC(scriptEntry).debug() + ArgumentHelper.debugObj("realistic", scriptEntry.getObject("realistic")) + ArgumentHelper.debugObj("range", scriptEntry.getObject("range")) + ArgumentHelper.debugObj("toggle", scriptEntry.getObject("toggle")));
        }
        LookClose trait = (LookClose)Utilities.getEntryNPC(scriptEntry).getCitizen().getTrait(LookClose.class);
        if (scriptEntry.hasObject("toggle")) {
            trait.lookClose(scriptEntry.getElement("toggle").asBoolean());
        }
        if (scriptEntry.hasObject("realistic")) {
            trait.setRealisticLooking(true);
        } else {
            trait.setRealisticLooking(false);
        }
        if (scriptEntry.hasObject("range")) {
            trait.setRange(scriptEntry.getElement("range").asInt());
        }
    }
}

