/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.citizensnpcs.trait.waypoint.Waypoints;
import org.bukkit.plugin.Plugin;

public class PauseCommand
extends AbstractCommand {
    private Map<String, Integer> durations = new ConcurrentHashMap<String, Integer>(8, 0.9f, 1);

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesArgumentType(DurationTag.class) && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
            }
            if (!scriptEntry.hasObject("pause_type") && arg.matchesEnum(PauseType.values())) {
                scriptEntry.addObject("pause_type", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("pause_type")) {
            throw new InvalidArgumentsException("Must specify a pause type!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        ElementTag pauseTypeElement = scriptEntry.getElement("pause_type");
        final PauseType pauseType = PauseType.valueOf(pauseTypeElement.asString().toUpperCase());
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (duration == null ? "" : duration.debug()) + pauseTypeElement.debug());
        }
        NPCTag npc = null;
        if (Utilities.getEntryNPC(scriptEntry) != null) {
            npc = Utilities.getEntryNPC(scriptEntry);
        }
        this.pause(npc, pauseType, !scriptEntry.getCommandName().equalsIgnoreCase("RESUME"));
        if (duration != null) {
            if (this.durations.containsKey(npc.getCitizen().getId() + pauseType.name())) {
                try {
                    DenizenAPI.getCurrentInstance().getServer().getScheduler().cancelTask(this.durations.get(npc.getCitizen().getId() + pauseType.name()).intValue());
                }
                catch (Exception e) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "There was an error pausing that!");
                    Debug.echoError(scriptEntry.getResidingQueue(), e);
                }
            }
            Debug.echoDebug((Debuggable)scriptEntry, "Running delayed task: Unpause " + pauseType.toString());
            final NPCTag theNpc = npc;
            final ScriptEntry se = scriptEntry;
            this.durations.put(npc.getId() + pauseType.name(), DenizenAPI.getCurrentInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    Debug.echoDebug((Debuggable)se, "Running delayed task: Pausing " + pauseType.toString());
                    PauseCommand.this.pause(theNpc, pauseType, false);
                }
            }, duration.getTicks()));
        }
    }

    public void pause(NPCTag denizen, PauseType pauseType, boolean pause) {
        switch (pauseType) {
            case WAYPOINTS: {
                ((Waypoints)denizen.getCitizen().getTrait(Waypoints.class)).getCurrentProvider().setPaused(pause);
                if (pause) {
                    denizen.getNavigator().cancelNavigation();
                }
                return;
            }
            case ACTIVITY: {
                denizen.getCitizen().getDefaultGoalController().setPaused(pause);
                return;
            }
        }
    }

    static enum PauseType {
        ACTIVITY,
        WAYPOINTS,
        NAVIGATION;

    }
}

