/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.List;

public class ShowFakeCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ListTag locations = new ListTag();
        ListTag entities = new ListTag();
        boolean added_entities = false;
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrefix("to", "players")) {
                for (String entity : ListTag.valueOf(arg.getValue())) {
                    if (!PlayerTag.matches(entity)) continue;
                    entities.add(entity);
                }
                added_entities = true;
                continue;
            }
            if (arg.matchesArgumentList(MaterialTag.class)) {
                scriptEntry.addObject("materials", arg.asType(ListTag.class));
                continue;
            }
            if (locations.isEmpty() && arg.matchesArgumentType(ListTag.class)) {
                for (String item : ListTag.valueOf(arg.getValue())) {
                    if (!LocationTag.matches(item)) continue;
                    locations.add(item);
                }
                continue;
            }
            if (locations.isEmpty() && arg.matchesArgumentType(LocationTag.class)) {
                locations.add(arg.getValue());
                continue;
            }
            if (arg.matchesPrefix("d", "duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matches("cancel")) {
                scriptEntry.addObject("cancel", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (entities.isEmpty() && Utilities.entryHasPlayer(scriptEntry)) {
            entities.add(Utilities.getEntryPlayer(scriptEntry).identify());
        }
        if (locations.isEmpty()) {
            throw new InvalidArgumentsException("Must specify at least one valid location!");
        }
        if (!(added_entities || Utilities.entryHasPlayer(scriptEntry) && Utilities.getEntryPlayer(scriptEntry).isOnline())) {
            throw new InvalidArgumentsException("Must have a valid, online player attached!");
        }
        if (entities.isEmpty() && added_entities) {
            throw new InvalidArgumentsException("Must specify valid targets!");
        }
        if (!scriptEntry.hasObject("materials") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Must specify valid material(s)!");
        }
        scriptEntry.addObject("entities", entities);
        scriptEntry.addObject("locations", locations);
        scriptEntry.defaultObject("duration", new DurationTag(10)).defaultObject("cancel", new ElementTag(false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        ListTag material_list = (ListTag)scriptEntry.getObjectTag("materials");
        ListTag list = (ListTag)scriptEntry.getObjectTag("locations");
        ListTag players = (ListTag)scriptEntry.getObjectTag("entities");
        ElementTag cancel = scriptEntry.getElement("cancel");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (material_list != null ? material_list.debug() : "") + list.debug() + players.debug() + duration.debug() + cancel.debug());
        }
        boolean shouldCancel = cancel.asBoolean();
        List<MaterialTag> mats = null;
        if (!shouldCancel) {
            mats = material_list.filter(MaterialTag.class, scriptEntry);
        }
        int i = 0;
        for (LocationTag loc : list.filter(LocationTag.class, scriptEntry)) {
            if (!shouldCancel) {
                FakeBlock.showFakeBlockTo(players.filter(PlayerTag.class, scriptEntry), loc, mats.get(i % mats.size()), duration);
            } else {
                FakeBlock.stopShowingTo(players.filter(PlayerTag.class, scriptEntry), loc);
            }
            ++i;
        }
    }
}

