/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InteractScriptContainer
extends ScriptContainer {
    private String defaultStep = null;
    private List<String> steps = new ArrayList<String>();

    public InteractScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        try {
            Set<StringHolder> keys = this.getConfigurationSection("STEPS").getKeys(false);
            if (this.contains("REQUIREMENTS")) {
                Debug.echoError("Interact script '" + this.getName() + "' is outdated: 'requirements' do not exist in modern Denizen!");
            }
            if (keys.isEmpty()) {
                throw new ExceptionInInitializerError("Could not find any STEPS in " + this.getName() + "! Is the type on this script correct?");
            }
            for (StringHolder step1 : keys) {
                String step = step1.str;
                if (step.contains("*")) {
                    YamlConfiguration defaultStepSection = this.getConfigurationSection("STEPS." + step);
                    step = step.replace("*", "");
                    this.set("STEPS." + step, defaultStepSection);
                    this.set("STEPS." + step + "*", null);
                    this.defaultStep = step;
                }
                if (step.equalsIgnoreCase("1")) {
                    this.defaultStep = step;
                }
                if (step.equalsIgnoreCase("DEFAULT")) {
                    this.defaultStep = step;
                }
                this.steps.add(step);
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        if (this.defaultStep == null && this.steps.size() == 1) {
            this.defaultStep = this.steps.get(0);
        }
        if (this.defaultStep == null) {
            throw new ExceptionInInitializerError("Must specify a default step in '" + this.getName() + "'!");
        }
    }

    public List<String> getStepNames() {
        return this.steps;
    }

    public String getDefaultStepName() {
        return this.defaultStep;
    }

    public boolean containsTriggerInStep(String step, Class<? extends AbstractTrigger> trigger) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        return this.contains("STEPS." + step.toUpperCase() + "." + triggerName + " TRIGGER");
    }

    public List<ScriptEntry> getEntriesFor(Class<? extends AbstractTrigger> trigger, PlayerTag player, NPCTag npc, String id) {
        return this.getEntriesFor(trigger, player, npc, id, false);
    }

    public List<ScriptEntry> getEntriesFor(Class<? extends AbstractTrigger> trigger, PlayerTag player, NPCTag npc, String id, boolean quiet) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        if (this.contains("STEPS." + InteractScriptHelper.getCurrentStep(player, this.getName()) + "." + triggerName + " TRIGGER." + (id == null ? "SCRIPT" : id.toUpperCase() + ".SCRIPT"))) {
            return this.getEntries(new BukkitScriptEntryData(player, npc), "STEPS." + InteractScriptHelper.getCurrentStep(player, this.getName()) + "." + triggerName + " TRIGGER." + (id == null ? "SCRIPT" : id.toUpperCase() + ".SCRIPT"));
        }
        if (!quiet) {
            Debug.echoDebug((Debuggable)this, "No entries in script for " + "STEPS." + InteractScriptHelper.getCurrentStep(player, this.getName()) + "." + triggerName + " TRIGGER." + (id == null ? "SCRIPT" : id.toUpperCase() + ".SCRIPT"));
        }
        return Collections.emptyList();
    }

    public Map<String, String> getIdMapFor(Class<? extends AbstractTrigger> trigger, PlayerTag player) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        if (this.contains("STEPS." + step + "." + triggerName + " TRIGGER")) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            try {
                for (StringHolder id : this.getConfigurationSection("STEPS." + step + "." + triggerName + " TRIGGER").getKeys(false)) {
                    if (id.str.equalsIgnoreCase("SCRIPT")) continue;
                    idMap.put(id.str, this.getString("STEPS." + step + "." + triggerName + " TRIGGER." + id.str + ".TRIGGER", ""));
                }
            }
            catch (Exception ex) {
                Debug.echoError("Warning: improperly defined " + trigger.getName() + " trigger for script '" + this.getName() + "'!");
            }
            return idMap;
        }
        return Collections.emptyMap();
    }

    public String getTriggerOptionFor(Class<? extends AbstractTrigger> trigger, PlayerTag player, String id, String option) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        return this.getString("STEPS." + step + "." + triggerName + " TRIGGER" + (id == null ? "" : "." + id.toUpperCase()) + "." + option.toUpperCase());
    }

    public boolean hasTriggerOptionFor(Class<? extends AbstractTrigger> trigger, PlayerTag player, String id, String option) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        return this.contains("STEPS." + step + "." + triggerName + " TRIGGER" + (id == null ? "" : "." + id.toUpperCase()) + "." + option.toUpperCase());
    }
}

