/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.maps;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.maps.DenizenMapManager;
import com.denizenscript.denizen.utilities.maps.MapObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import javax.swing.ImageIcon;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;

public class MapImage
extends MapObject {
    protected boolean useCache;
    protected byte[] cachedImage;
    protected Image image;
    protected ImageIcon imageIcon;
    protected int width = 0;
    protected int height = 0;
    protected String fileTag;
    protected String actualFile = null;
    boolean disabled = false;
    private static final Color[] bukkitColors;

    public MapImage(String xTag, String yTag, String visibilityTag, boolean debug, String fileTag, int width, int height) {
        this(xTag, yTag, visibilityTag, debug, fileTag, width, height, true);
    }

    public MapImage(String xTag, String yTag, String visibilityTag, boolean debug, String fileTag, int width, int height, boolean useCache) {
        super(xTag, yTag, visibilityTag, debug);
        this.useCache = useCache;
        if (useCache) {
            this.cachedImage = null;
        }
        this.fileTag = fileTag;
        if (width > 0 || height > 0) {
            this.width = width > 0 ? width : 0;
            this.height = height > 0 ? height : 0;
        }
    }

    protected void setImage(Image image) {
        this.image = image;
    }

    @Override
    public Map<String, Object> getSaveData() {
        Map<String, Object> data = super.getSaveData();
        data.put("type", "IMAGE");
        data.put("width", this.width);
        data.put("height", this.height);
        data.put("image", this.fileTag);
        return data;
    }

    @Override
    public void render(MapView mapView, MapCanvas mapCanvas, PlayerTag player, UUID uuid) {
        byte[] bytes;
        if (this.actualFile == null) {
            this.actualFile = DenizenMapManager.getActualFile(this.fileTag);
            if (this.actualFile == null) {
                return;
            }
            this.imageIcon = new ImageIcon(this.actualFile);
            this.image = this.imageIcon.getImage();
            if (this.width == 0) {
                this.width = this.image.getWidth(null);
            }
            if (this.height == 0) {
                this.height = this.image.getHeight(null);
            }
            if (this.width == -1 || this.height == -1) {
                Debug.echoError("Image loading failed (bad width/height) for image " + this.fileTag);
                this.disabled = true;
                return;
            }
            this.disabled = false;
        }
        if (this.disabled) {
            return;
        }
        if (!this.useCache || this.cachedImage == null) {
            bytes = MapImage.imageToBytes(this.image, this.width, this.height);
            if (bytes == null) {
                Debug.echoError("Image loading failed (bad imageToBytes) for image " + this.fileTag);
                this.disabled = true;
                return;
            }
            if (this.useCache) {
                this.cachedImage = bytes;
            }
        } else {
            bytes = this.cachedImage;
        }
        int x = this.getX(player, uuid);
        int y = this.getY(player, uuid);
        for (int x2 = 0; x2 < this.width; ++x2) {
            for (int y2 = 0; y2 < this.height; ++y2) {
                byte p = bytes[y2 * this.width + x2];
                if (p == 0) continue;
                mapCanvas.setPixel(x + x2, y + y2, p);
            }
        }
    }

    public static byte[] imageToBytes(Image image, int width, int height) {
        BufferedImage temp = new BufferedImage(width, height, 2);
        Graphics2D graphics = temp.createGraphics();
        graphics.drawImage(image, 0, 0, width, height, null);
        graphics.dispose();
        int[] pixels = new int[width * height];
        temp.getRGB(0, 0, width, height, pixels, 0, width);
        byte[] result = new byte[width * height];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = MapImage.matchColor(new Color(pixels[i]));
        }
        return result;
    }

    public static byte matchColor(Color color) {
        if (color.getAlpha() < 128) {
            return 0;
        }
        int index = 0;
        double best = -1.0;
        for (int i = 4; i < bukkitColors.length; ++i) {
            double distance = MapImage.getDistance(color, bukkitColors[i]);
            if (!(distance < best) && best != -1.0) continue;
            best = distance;
            index = i;
        }
        return (byte)(index < 128 ? index : -129 + (index - 127));
    }

    public static double getDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        double r = c1.getRed() - c2.getRed();
        double g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return weightR * r * r + weightG * g * g + weightB * (double)b * (double)b;
    }

    static {
        Color[] colors = null;
        try {
            Field field = MapPalette.class.getDeclaredField("colors");
            field.setAccessible(true);
            colors = (Color[])field.get(null);
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        bukkitColors = colors;
    }
}

