/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashSet;

public class Argument
implements Cloneable {
    public String raw_value;
    public String prefix = null;
    public String lower_prefix = null;
    public String value;
    public String lower_value;
    public ObjectTag object = null;
    public boolean needsFill = false;
    public boolean hasSpecialPrefix = false;
    public ScriptEntry scriptEntry = null;

    public Argument clone() {
        try {
            return (Argument)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public String generateRaw() {
        return this.prefix == null ? this.value : this.prefix + ":" + this.value;
    }

    public Argument(String prefix, String value) {
        this.prefix = prefix;
        this.value = TagManager.cleanOutputFully(value);
        if (prefix != null) {
            if (prefix.equals("no_prefix")) {
                this.prefix = null;
                this.raw_value = this.value;
            } else {
                this.raw_value = prefix + ":" + this.value;
                this.lower_prefix = CoreUtilities.toLowerCase(prefix);
            }
        } else {
            this.raw_value = this.value;
        }
        this.lower_value = CoreUtilities.toLowerCase(this.value);
        this.object = new ElementTag(this.value);
    }

    public Argument(String prefix, ObjectTag value) {
        this.prefix = prefix;
        this.value = TagManager.cleanOutputFully(value.toString());
        if (prefix != null) {
            if (prefix.equals("no_prefix")) {
                this.prefix = null;
                this.raw_value = this.value;
            } else {
                this.raw_value = prefix + ":" + this.value;
                this.lower_prefix = CoreUtilities.toLowerCase(prefix);
            }
        } else {
            this.raw_value = this.value;
        }
        this.lower_value = CoreUtilities.toLowerCase(this.value);
        this.object = value instanceof ElementTag ? new ElementTag(this.value) : value;
    }

    public Argument(ObjectTag obj) {
        this.object = obj;
        if (obj instanceof ElementTag) {
            this.fillStr(obj.toString());
        } else {
            this.value = this.raw_value = TagManager.cleanOutputFully(obj.toString());
            this.lower_value = CoreUtilities.toLowerCase(this.value);
        }
    }

    void fillStr(String string) {
        this.raw_value = string = TagManager.cleanOutputFully(string);
        int first_colon = string.indexOf(58);
        int first_space = string.indexOf(32);
        if (first_space > -1 && first_space < first_colon || first_colon == -1) {
            this.value = string;
            if (this.object == null) {
                this.object = new ElementTag(this.value);
            }
        } else {
            this.prefix = string.substring(0, first_colon);
            if (this.prefix.equals("no_prefix")) {
                this.prefix = null;
            } else {
                this.lower_prefix = CoreUtilities.toLowerCase(this.prefix);
            }
            this.value = string.substring(first_colon + 1);
            this.object = new ElementTag(this.value);
        }
        this.lower_value = CoreUtilities.toLowerCase(this.value);
    }

    public Argument(String string) {
        this.fillStr(string);
    }

    public static Argument valueOf(String string) {
        return new Argument(string);
    }

    public boolean startsWith(String string) {
        return this.lower_value.startsWith(CoreUtilities.toLowerCase(string));
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public Argument getPrefix() {
        if (this.prefix == null) {
            return null;
        }
        return Argument.valueOf(this.prefix);
    }

    public boolean matches(String values) {
        if (!CoreUtilities.contains(values, ',')) {
            return CoreUtilities.toLowerCase(values).equals(this.lower_value);
        }
        for (String value : CoreUtilities.split(values, ',')) {
            if (!CoreUtilities.toLowerCase(value.replace(" ", "")).equals(this.lower_value)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesOne(String value) {
        return CoreUtilities.toLowerCase(value).equals(this.lower_value);
    }

    public boolean matches(String ... values) {
        for (String value : values) {
            if (!CoreUtilities.toLowerCase(value).equals(this.lower_value)) continue;
            return true;
        }
        return false;
    }

    public void replaceValue(String string) {
        this.value = string;
        this.lower_value = CoreUtilities.toLowerCase(this.value);
    }

    public String getValue() {
        return this.value;
    }

    public ListTag getList() {
        if (this.object instanceof ListTag) {
            return (ListTag)this.object;
        }
        return ListTag.valueOf(this.value);
    }

    public static HashSet<String> precalcEnum(Enum<?>[] values) {
        HashSet<String> toRet = new HashSet<String>(values.length);
        for (int i = 0; i < values.length; ++i) {
            toRet.add(values[i].name().toUpperCase().replace("_", ""));
        }
        return toRet;
    }

    public boolean matchesEnum(HashSet<String> values) {
        String upper = this.value.replace("_", "").toUpperCase();
        return values.contains(upper);
    }

    public boolean matchesEnumList(HashSet<String> values) {
        ListTag list = this.getList();
        for (String string : list) {
            String tval = string.replace("_", "").toUpperCase();
            if (!values.contains(tval)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesEnum(Enum<?>[] values) {
        String upper = this.value.replace("_", "").toUpperCase();
        for (Enum<?> value : values) {
            if (!value.name().replace("_", "").equals(upper)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesEnumList(Enum<?>[] values) {
        ListTag list = this.getList();
        for (String string : list) {
            String tval = string.replace("_", "").toUpperCase();
            for (Enum<?> value : values) {
                if (!value.name().replace("_", "").equalsIgnoreCase(tval)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesPrefix(String values) {
        if (!this.hasPrefix()) {
            return false;
        }
        if (!CoreUtilities.contains(values, ',')) {
            return CoreUtilities.toLowerCase(values).equals(this.lower_prefix);
        }
        for (String value : CoreUtilities.split(values, ',')) {
            if (!CoreUtilities.toLowerCase(value.trim()).equals(this.lower_prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesOnePrefix(String value) {
        if (!this.hasPrefix()) {
            return false;
        }
        return CoreUtilities.toLowerCase(value).equals(this.lower_prefix);
    }

    public boolean matchesPrefix(String ... values) {
        if (!this.hasPrefix()) {
            return false;
        }
        for (String value : values) {
            if (!CoreUtilities.toLowerCase(value).equals(this.lower_prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesPrimitive(ArgumentHelper.PrimitiveType argumentType) {
        if (this.value == null) {
            return false;
        }
        switch (argumentType) {
            case Word: {
                return ArgumentHelper.wordPrimitive.matcher(this.value).matches();
            }
            case Integer: {
                return ArgumentHelper.doublePrimitive.matcher(this.value).matches();
            }
            case Double: {
                return ArgumentHelper.doublePrimitive.matcher(this.value).matches();
            }
            case Float: {
                return ArgumentHelper.floatPrimitive.matcher(this.value).matches();
            }
            case Boolean: {
                return ArgumentHelper.booleanPrimitive.matcher(this.value).matches();
            }
            case Percentage: {
                return ArgumentHelper.percentagePrimitive.matcher(this.value).matches();
            }
            case String: {
                return true;
            }
        }
        return false;
    }

    public boolean matchesArgumentType(Class<? extends ObjectTag> dClass) {
        return CoreUtilities.canPossiblyBeType(this.object, dClass);
    }

    public boolean matchesArgumentTypes(Class<? extends ObjectTag> ... dClasses) {
        for (Class<? extends ObjectTag> c : dClasses) {
            if (!this.matchesArgumentType(c)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesArgumentList(Class<? extends ObjectTag> dClass) {
        ListTag list = this.getList();
        return list.isEmpty() || list.containsObjectsFrom(dClass);
    }

    public ElementTag asElement() {
        if (this.object instanceof ElementTag) {
            return (ElementTag)this.object;
        }
        return new ElementTag(this.prefix, this.value);
    }

    public <T extends ObjectTag> T asType(Class<T> clazz) {
        T arg = CoreUtilities.asType(this.object, clazz, DenizenCore.getImplementation().getTagContext(this.scriptEntry));
        if (arg != null) {
            arg.setPrefix(this.prefix);
            return arg;
        }
        return null;
    }

    public void reportUnhandled() {
        Debug.echoError('\'' + this.raw_value + "' is an unknown argument!");
    }

    public String toString() {
        return this.raw_value;
    }
}

