/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.CustomObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectFetcher {
    private static Map<String, Class> objects = new HashMap<String, Class>();
    static Map<Class, MatchesInterface> matches = new HashMap<Class, MatchesInterface>();
    static Map<Class, ValueOfInterface> valueof = new HashMap<Class, ValueOfInterface>();
    private static ArrayList<Class> fetchable_objects = new ArrayList();
    static final Pattern PROPERTIES_PATTERN = Pattern.compile("([^\\[]+)\\[(.+=.+)\\]", 42);
    public static final Pattern DESCRIBED_PATTERN = Pattern.compile("[^\\[]+\\[.+=.+\\]", 40);

    public static void _initialize() throws IOException, ClassNotFoundException {
        if (fetchable_objects.isEmpty()) {
            return;
        }
        HashMap<String, Class> adding = new HashMap<String, Class>();
        for (Class dClass : fetchable_objects) {
            try {
                String[] identifiers;
                Method method = dClass.getMethod("valueOf", String.class, TagContext.class);
                if (!method.isAnnotationPresent(Fetchable.class)) continue;
                for (String identifier : identifiers = method.getAnnotation(Fetchable.class).value().split(",")) {
                    adding.put(CoreUtilities.toLowerCase(identifier.trim()), dClass);
                    Debug.log("Registered: " + dClass.getSimpleName() + " as " + identifier);
                }
            }
            catch (Throwable e) {
                Debug.echoError("Failed to initialize an object type(" + dClass.getSimpleName() + "): ");
                Debug.echoError(e);
            }
        }
        objects.putAll(adding);
        Debug.echoApproval("Added objects to the ObjectFetcher " + adding.keySet().toString());
        fetchable_objects.clear();
    }

    public static void _registerCoreObjects() throws NoSuchMethodException, ClassNotFoundException, IOException {
        ObjectFetcher.registerWithObjectFetcher(CustomObjectTag.class);
        ObjectFetcher.registerWithObjectFetcher(ListTag.class);
        ListTag.registerTags();
        ObjectFetcher.registerWithObjectFetcher(ScriptTag.class);
        ScriptTag.registerTags();
        ObjectFetcher.registerWithObjectFetcher(ElementTag.class);
        ElementTag.registerTags();
        ObjectFetcher.registerWithObjectFetcher(DurationTag.class);
        DurationTag.registerTags();
        ObjectFetcher.registerWithObjectFetcher(QueueTag.class);
        QueueTag.registerTags();
        ObjectFetcher._initialize();
    }

    public static MatchesInterface getMatchesFor(Class clazz) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CallSite site = LambdaMetafactory.metafactory(lookup, "matches", MethodType.methodType(MatchesInterface.class), MethodType.methodType(Boolean.class, String.class).unwrap(), lookup.findStatic(clazz, "matches", MethodType.methodType(Boolean.class, String.class).unwrap()), MethodType.methodType(Boolean.class, String.class).unwrap());
            return site.getTarget().invoke();
        }
        catch (Throwable ex) {
            System.err.println("Failed to get matches for " + clazz.getCanonicalName());
            ex.printStackTrace();
            Debug.echoError(ex);
            return null;
        }
    }

    public static ValueOfInterface getValueOfFor(Class clazz) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CallSite site = LambdaMetafactory.metafactory(lookup, "valueOf", MethodType.methodType(ValueOfInterface.class), MethodType.methodType(ObjectTag.class, String.class, TagContext.class), lookup.findStatic(clazz, "valueOf", MethodType.methodType(clazz, String.class, TagContext.class)), MethodType.methodType(clazz, String.class, TagContext.class));
            return site.getTarget().invoke();
        }
        catch (Throwable ex) {
            System.err.println("Failed to get valueOf for " + clazz.getCanonicalName());
            ex.printStackTrace();
            Debug.echoError(ex);
            return null;
        }
    }

    public static void registerWithObjectFetcher(Class<? extends ObjectTag> objectTag) {
        try {
            fetchable_objects.add(objectTag);
            matches.put(objectTag, ObjectFetcher.getMatchesFor(objectTag));
            valueof.put(objectTag, ObjectFetcher.getValueOfFor(objectTag));
        }
        catch (Throwable e) {
            Debug.echoError("Failed to register an object type (" + objectTag.getSimpleName() + "): ");
            Debug.echoError(e);
        }
    }

    public static boolean canFetch(String id) {
        return objects.containsKey(CoreUtilities.toLowerCase(id));
    }

    public static Class getObjectClass(String id) {
        if (ObjectFetcher.canFetch(id)) {
            return objects.get(CoreUtilities.toLowerCase(id));
        }
        return null;
    }

    public static boolean checkMatch(Class<? extends ObjectTag> dClass, String value) {
        if (value == null || dClass == null) {
            return false;
        }
        Matcher m = PROPERTIES_PATTERN.matcher(value);
        try {
            return matches.get(dClass).matches(m.matches() ? m.group(1) : value);
        }
        catch (Exception e) {
            Debug.echoError(e);
            return false;
        }
    }

    @Deprecated
    public static <T extends ObjectTag> T getObjectFrom(Class<T> dClass, String value) {
        return ObjectFetcher.getObjectFrom(dClass, value, DenizenCore.getImplementation().getTagContext(null));
    }

    public static List<String> separateProperties(String input) {
        if (input.indexOf(91) == -1 || input.lastIndexOf(93) != input.length() - 1) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>();
        int start = 0;
        boolean needObject = true;
        int brackets = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '[' && needObject) {
                needObject = false;
                output.add(input.substring(start, i));
                start = i + 1;
                continue;
            }
            if (input.charAt(i) == '[') {
                ++brackets;
                continue;
            }
            if (input.charAt(i) == ']' && brackets > 0) {
                --brackets;
                continue;
            }
            if (input.charAt(i) != ';' && input.charAt(i) != ']' || brackets != 0) continue;
            output.add(input.substring(start, i));
            start = i + 1;
        }
        return output;
    }

    public static <T extends ObjectTag> T getObjectFrom(Class<T> dClass, String value, TagContext context) {
        try {
            List<String> matches = ObjectFetcher.separateProperties(value);
            boolean matched = matches != null && Adjustable.class.isAssignableFrom(dClass);
            ObjectTag gotten = valueof.get(dClass).valueOf(matched ? matches.get(0) : value, context);
            if (gotten != null && matched) {
                for (int i = 1; i < matches.size(); ++i) {
                    List<String> data = CoreUtilities.split(matches.get(i), '=', 2);
                    if (data.size() != 2) {
                        Debug.echoError("Invalid property string '" + matches.get(i) + "'!");
                        continue;
                    }
                    ((Adjustable)gotten).safeApplyProperty(new Mechanism(new ElementTag(data.get(0)), new ElementTag(data.get(1).replace('\u2011', ';')), context));
                }
            }
            return (T)gotten;
        }
        catch (Exception e) {
            Debug.echoError(e);
            return null;
        }
    }

    public static ObjectTag pickObjectFor(String value) {
        return ObjectFetcher.pickObjectFor(value, DenizenCore.getImplementation().getEmptyScriptEntryData().getTagContext());
    }

    public static ObjectTag pickObjectFor(String value, TagContext context) {
        Class toFetch;
        Object fetched;
        String type;
        if (value == null) {
            return null;
        }
        if (value.contains("@") && ObjectFetcher.canFetch(type = value.split("@", 2)[0]) && (fetched = ObjectFetcher.getObjectFrom(toFetch = ObjectFetcher.getObjectClass(type), value, context)) != null) {
            return fetched;
        }
        return new ElementTag(value);
    }

    public static interface ValueOfInterface {
        public ObjectTag valueOf(String var1, TagContext var2);
    }

    @FunctionalInterface
    public static interface MatchesInterface {
        public boolean matches(String var1);
    }
}

