/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.Delayable;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;

public class QueueTag
implements ObjectTag,
ObjectTag.ObjectAttributable,
Adjustable {
    public ScriptQueue queue;
    String prefix = "Queue";
    public static HashMap<String, TagRunnable.ObjectForm> registeredObjectTags = new HashMap();

    public static QueueTag valueOf(String string) {
        return QueueTag.valueOf(string, null);
    }

    @Fetchable(value="q")
    public static QueueTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("q@") && string.length() > 2) {
            string = string.substring(2);
        }
        if (ScriptQueue.queueExists(string)) {
            return new QueueTag(ScriptQueue.getExistingQueue(string));
        }
        return null;
    }

    public static boolean matches(String string) {
        return CoreUtilities.toLowerCase(string).startsWith("q@");
    }

    public QueueTag(ScriptQueue queue) {
        this.queue = queue;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public QueueTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "queue";
    }

    @Override
    public String identify() {
        return "q@" + this.queue.id;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        QueueTag.registerTag("id", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((QueueTag)object).queue.id).getObjectAttribute(attribute.fulfill(1));
            }
        });
        QueueTag.registerTag("size", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((QueueTag)object).queue.script_entries.size()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        QueueTag.registerTag("start_time", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new DurationTag(((QueueTag)object).queue.startTimeMilli / 50L).getObjectAttribute(attribute.fulfill(1));
            }
        });
        QueueTag.registerTag("time_ran", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                long timeNano = System.nanoTime() - ((QueueTag)object).queue.startTime;
                return new DurationTag((double)timeNano / 1.0E9).getObjectAttribute(attribute.fulfill(1));
            }
        });
        QueueTag.registerTag("state", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                String state = ((QueueTag)object).queue instanceof Delayable && ((Delayable)((Object)((QueueTag)object).queue)).isPaused() ? "paused" : (((QueueTag)object).queue.is_started ? "running" : (((QueueTag)object).queue.is_stopping ? "stopping" : "unknown"));
                return new ElementTag(state).getObjectAttribute(attribute.fulfill(1));
            }
        });
        QueueTag.registerTag("script", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((QueueTag)object).queue.script == null) {
                    return null;
                }
                return ((QueueTag)object).queue.script.getObjectAttribute(attribute.fulfill(1));
            }
        });
        QueueTag.registerTag("commands", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag commands = new ListTag();
                for (ScriptEntry entry : ((QueueTag)object).queue.script_entries) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(entry.getCommandName()).append(" ");
                    for (String arg : entry.getOriginalArguments()) {
                        sb.append(arg).append(" ");
                    }
                    commands.add(sb.substring(0, sb.length() - 1));
                }
                return commands.getObjectAttribute(attribute.fulfill(1));
            }
        });
        QueueTag.registerTag("definitions", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ListTag(((QueueTag)object).queue.getAllDefinitions().keySet()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        QueueTag.registerTag("definition", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag QueueTag.definition[...] must have a value.");
                    return null;
                }
                return CoreUtilities.autoAttrib(((QueueTag)object).queue.getDefinitionObject(attribute.getContext(1)), attribute.fulfill(1));
            }
        });
        QueueTag.registerTag("determination", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((QueueTag)object).queue.determinations == null) {
                    return null;
                }
                return ((QueueTag)object).queue.determinations.getObjectAttribute(attribute.fulfill(1));
            }
        });
        QueueTag.registerTag("speed", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!(((QueueTag)object).queue instanceof TimedQueue)) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("The tag QueueTag.speed is only valid for Timed queues.");
                    }
                    return null;
                }
                return CoreUtilities.autoAttrib(((TimedQueue)((QueueTag)object).queue).getSpeed(), attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredObjectTags.put(name, runnable);
    }

    @Override
    public <T extends ObjectTag> T asObjectType(Class<T> type, TagContext context) {
        return null;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        return CoreUtilities.stringifyNullPass(this.getObjectAttribute(attribute));
    }

    @Override
    public Class<? extends ObjectTag> getdObjectClass() {
        return QueueTag.class;
    }

    public void ensure() {
        while (this.queue.replacementQueue != null) {
            this.queue = this.queue.replacementQueue;
        }
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.isComplete()) {
            return this;
        }
        this.ensure();
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable.ObjectForm otr = registeredObjectTags.get(attrLow);
        if (otr != null) {
            if (!otr.name.equals(attrLow)) {
                Debug.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + otr.name + "': '" + attrLow + "'.");
            }
            return otr.run(attribute, this);
        }
        ObjectTag returned = CoreUtilities.autoPropertyTagObject(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new ElementTag(this.identify()).getObjectAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("QueueTags can not hold properties.");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        this.ensure();
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

