/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class ScriptTag
implements ObjectTag,
Adjustable {
    private ScriptContainer container;
    private String prefix = "Container";
    private boolean valid = false;
    private String name = null;
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static ScriptTag valueOf(String string) {
        return ScriptTag.valueOf(string, null);
    }

    @Fetchable(value="s")
    public static ScriptTag valueOf(String string, TagContext context) {
        ScriptTag script;
        if (string.startsWith("s@")) {
            string = string.substring(2);
        }
        if ((script = new ScriptTag(string)).isValid()) {
            return script;
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("s@")) {
            return true;
        }
        ScriptTag script = new ScriptTag(string);
        return script.isValid();
    }

    public ScriptTag(String scriptName) {
        if (ScriptRegistry.getScriptContainer(scriptName) != null) {
            this.container = ScriptRegistry.getScriptContainer(scriptName);
            this.name = scriptName.toUpperCase();
            this.valid = true;
        }
    }

    public ScriptTag(ScriptContainer container) {
        this.container = container;
        this.name = container.getName().toUpperCase();
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getType() {
        return this.container != null ? this.container.getContainerType() : "invalid";
    }

    public String getName() {
        return this.name;
    }

    public ScriptContainer getContainer() {
        return this.container;
    }

    @Override
    public String getObjectType() {
        return "Container";
    }

    @Override
    public String identify() {
        return "s@" + this.name;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        return "s@" + this.name + "<GR> (" + this.getType() + ")";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    public static void registerTags() {
        ScriptTag.registerTag("container_type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ScriptTag)object).container.getContainerType()).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ScriptTag)object).name).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("relative_filename", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ScriptTag)object).container.getRelativeFileName()).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("filename", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ScriptTag)object).container.getFileName().replace("\\", "/")).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("original_name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ScriptTag)object).container.getOriginalName()).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("constant", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ScriptTag.constant[...] must have a value.");
                    return null;
                }
                YamlConfiguration section = ((ScriptTag)object).getContainer().getConfigurationSection("default constants");
                if (section == null) {
                    return null;
                }
                Object obj = section.get(attribute.getContext(1).toUpperCase());
                if (obj == null) {
                    return null;
                }
                if (obj instanceof List) {
                    ListTag list = new ListTag();
                    for (Object each : (List)obj) {
                        if (each == null) {
                            each = "null";
                        }
                        list.add(TagManager.tag(each.toString(), DenizenCore.getImplementation().getTagContext(attribute.getScriptEntry())));
                    }
                    return list.getAttribute(attribute.fulfill(1));
                }
                return new ElementTag(TagManager.tag(obj.toString(), DenizenCore.getImplementation().getTagContext(attribute.getScriptEntry()))).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("yaml_key", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ScriptTag.constant[...] must have a value.");
                    return null;
                }
                ScriptTag scr = (ScriptTag)object;
                ScriptContainer container = scr.getContainer();
                if (container == null) {
                    Debug.echoError("Missing script container?!");
                    return new ElementTag(scr.identify()).getAttribute(attribute);
                }
                YamlConfiguration section = container.getConfigurationSection("");
                if (section == null) {
                    Debug.echoError("Missing YAML section?!");
                    return new ElementTag(scr.identify()).getAttribute(attribute);
                }
                Object obj = section.get(attribute.getContext(1).toUpperCase());
                if (obj == null) {
                    return null;
                }
                if (obj instanceof List) {
                    ListTag list = new ListTag();
                    for (Object each : (List)obj) {
                        if (each == null) {
                            each = "null";
                        }
                        list.add(ScriptBuilder.stripLinePrefix(each.toString()));
                    }
                    return list.getAttribute(attribute.fulfill(1));
                }
                return new ElementTag(obj.toString()).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("list_keys", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                YamlConfiguration conf = ((ScriptTag)object).getContainer().getConfigurationSection(attribute.hasContext(1) ? attribute.getContext(1) : "");
                if (conf == null) {
                    return null;
                }
                return new ListTag(conf.getKeys(false)).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("list_deep_keys", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                YamlConfiguration conf = ((ScriptTag)object).getContainer().getConfigurationSection(attribute.hasContext(1) ? attribute.getContext(1) : "");
                if (conf == null) {
                    return null;
                }
                return new ListTag(conf.getKeys(true)).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("to_json", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                JSONObject jsobj = new JSONObject(YamlConfiguration.reverse(((ScriptTag)object).container.getContents().getMap(), true));
                jsobj.remove("TYPE");
                return new ElementTag(jsobj.toString()).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("to_text", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                YamlConfiguration config = new YamlConfiguration();
                config.addAll(((ScriptTag)object).getContainer().getContents().getMap());
                config.set("type", null);
                return new ElementTag(config.saveToString(true)).getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag("Script").getAttribute(attribute.fulfill(1));
            }
        });
        ScriptTag.registerTag("list_queues", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ScriptTag script = (ScriptTag)object;
                ListTag queues = new ListTag();
                for (ScriptQueue queue : ScriptQueue.getQueues()) {
                    if (queue.script == null || !queue.script.getName().equals(script.getName())) continue;
                    queues.addObject(new QueueTag(queue));
                }
                return queues.getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                Debug.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a script!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

