/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.queues.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.Delayable;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.RepeatingSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.Schedulable;

public class TimedQueue
extends ScriptQueue
implements Delayable {
    private Schedulable schedulable;
    private long ticks;
    protected boolean paused = false;
    protected long delay_ticks = 0L;

    public static TimedQueue getQueue(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID cannot be null!");
        }
        TimedQueue scriptQueue = TimedQueue.queueExists(id) ? (TimedQueue)ScriptQueue.allQueues.get(id) : new TimedQueue(id, DurationTag.valueOf(DenizenCore.getImplementation().scriptQueueSpeed()));
        return scriptQueue;
    }

    @Override
    public void delayFor(DurationTag duration) {
        this.delay_ticks = DenizenCore.serverTimeMillis + duration.getMillis();
    }

    @Override
    public boolean isDelayed() {
        return this.delay_ticks > DenizenCore.serverTimeMillis;
    }

    public TimedQueue(String id) {
        this(id, DurationTag.valueOf(DenizenCore.getImplementation().scriptQueueSpeed()));
    }

    public TimedQueue(String id, long ticks) {
        super(id);
        this.ticks = ticks;
    }

    public TimedQueue(String id, DurationTag timing) {
        super(id);
        this.ticks = timing.getTicks();
    }

    @Override
    public boolean isInstantSpeed() {
        return this.ticks <= 0L;
    }

    public DurationTag getSpeed() {
        return new DurationTag(this.ticks);
    }

    @Override
    public Delayable setPaused(boolean paused) {
        this.paused = paused;
        return this;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public TimedQueue setSpeed(long ticks) {
        this.ticks = ticks;
        return this;
    }

    @Override
    protected void onStart() {
        this.revolve();
        if (this.script_entries.isEmpty()) {
            return;
        }
        Schedulable schedulable = new RepeatingSchedulable(new Runnable(){

            @Override
            public void run() {
                TimedQueue.this.revolve();
            }
        }, (float)(this.ticks <= 0L ? 1L : this.ticks) / 20.0f);
        if (this.run_async) {
            schedulable = new AsyncSchedulable(schedulable);
        }
        this.schedulable = schedulable;
        DenizenCore.schedule(schedulable);
    }

    @Override
    public String getName() {
        return "TimedQueue";
    }

    @Override
    protected void onStop() {
        if (this.schedulable != null) {
            this.schedulable.cancel();
        }
    }

    @Override
    protected boolean shouldRevolve() {
        if (this.paused) {
            return false;
        }
        return !this.isDelayed();
    }
}

