/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.List;

public class ReplaceableTagEvent {
    private final TagContext context;
    private boolean wasReplaced = false;
    private ObjectTag alternative_tagged = null;
    private String replaced = null;
    private String value_tagged = null;
    private Attribute core_attributes = null;
    public String raw_tag;
    public ObjectTag replaced_obj = null;
    public ReferenceData mainRef = null;
    public static HashMap<String, ReferenceData> refs = new HashMap();

    public ObjectTag getReplacedObj() {
        if (this.replaced_obj == null) {
            if (this.replaced == null) {
                return null;
            }
            this.replaced_obj = new ElementTag(this.replaced);
        }
        return this.replaced_obj;
    }

    public ReplaceableTagEvent(ReferenceData ref, String tag, TagContext context) {
        this.context = context;
        this.replaced = tag;
        if (ref != null) {
            this.mainRef = ref;
            this.core_attributes = new Attribute(ref.attribs, context.entry, context);
            this.raw_tag = ref.rawTag;
        }
    }

    public ReplaceableTagEvent(String tag, TagContext context) {
        this(refs.get(tag), tag, context);
        int valueLoc;
        int alternativeLoc;
        char start;
        if (this.mainRef != null) {
            return;
        }
        String otag = tag;
        this.mainRef = new ReferenceData();
        if (tag.length() > 0 && ((start = tag.charAt(0)) == '!' || start == '^')) {
            this.mainRef.isInstant = true;
            tag = tag.substring(1);
        }
        if ((alternativeLoc = ReplaceableTagEvent.locateAlternative(tag)) >= 0) {
            this.mainRef.alternative = tag.substring(alternativeLoc + 2).trim();
            tag = tag.substring(0, alternativeLoc);
        }
        if ((valueLoc = ReplaceableTagEvent.locateValue(tag)) > 0) {
            this.mainRef.value = tag.substring(valueLoc + 1);
            tag = tag.substring(0, valueLoc);
        }
        this.raw_tag = tag.trim();
        this.core_attributes = new Attribute(this.raw_tag, context.entry, context);
        this.core_attributes.setHadAlternative(this.hasAlternative());
        this.mainRef.attribs = new Attribute(this.core_attributes, null, null);
        this.mainRef.rawTag = this.raw_tag;
        refs.put(otag, this.mainRef);
    }

    private static int locateValue(String tag) {
        int bracks = 0;
        int bracks2 = 0;
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (c == '<') {
                ++bracks;
                continue;
            }
            if (c == '>') {
                --bracks;
                continue;
            }
            if (bracks == 0 && c == '[') {
                ++bracks2;
                continue;
            }
            if (bracks == 0 && c == ']') {
                --bracks2;
                continue;
            }
            if (c != ':' || bracks != 0 || bracks2 != 0) continue;
            return i;
        }
        return -1;
    }

    private static int locateAlternative(String tag) {
        int bracks = 0;
        int bracks2 = 0;
        boolean previousWasTarget = false;
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (c == '<') {
                ++bracks;
                continue;
            }
            if (c == '>') {
                --bracks;
                continue;
            }
            if (bracks == 0 && c == '[') {
                ++bracks2;
                continue;
            }
            if (bracks == 0 && c == ']') {
                --bracks2;
                continue;
            }
            if (c == '|' && bracks == 0 && bracks2 == 0) {
                if (previousWasTarget) {
                    return i - 1;
                }
                previousWasTarget = true;
                continue;
            }
            previousWasTarget = false;
        }
        return -1;
    }

    public boolean matches(String tagName) {
        if (!tagName.contains(",")) {
            return this.getName().equals(tagName);
        }
        List<String> tagNames = CoreUtilities.split(tagName, ',');
        String name = this.getName();
        for (String string : tagNames) {
            if (!name.equals(string.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String ... tagNames) {
        String name = this.getName();
        for (String string : tagNames) {
            if (!name.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String StripContext(String input) {
        if (input == null) {
            return null;
        }
        int index = input.indexOf(91);
        if (index < 0 || !input.endsWith("]")) {
            return input;
        }
        return input.substring(0, index);
    }

    public String getName() {
        return this.core_attributes.getAttributeWithoutContext(1);
    }

    public String getNameContext() {
        return this.core_attributes.getContext(1);
    }

    public boolean hasNameContext() {
        return this.core_attributes.hasContext(1);
    }

    @Deprecated
    public String getType() {
        return this.core_attributes.getAttributeWithoutContext(2);
    }

    @Deprecated
    public boolean hasType() {
        return this.core_attributes.getAttribute(2).length() > 0;
    }

    @Deprecated
    public String getTypeContext() {
        return this.core_attributes.getContext(2);
    }

    @Deprecated
    public boolean hasTypeContext() {
        return this.core_attributes.hasContext(2);
    }

    @Deprecated
    public String getSubType() {
        return this.core_attributes.getAttributeWithoutContext(3);
    }

    @Deprecated
    public boolean hasSubType() {
        return this.core_attributes.getAttribute(3).length() > 0;
    }

    @Deprecated
    public String getSubTypeContext() {
        return this.core_attributes.getContext(3);
    }

    @Deprecated
    public boolean hasSubTypeContext() {
        return this.core_attributes.hasContext(3);
    }

    @Deprecated
    public String getSpecifier() {
        return this.core_attributes.getAttributeWithoutContext(4);
    }

    @Deprecated
    public boolean hasSpecifier() {
        return this.core_attributes.getAttribute(4).length() > 0;
    }

    @Deprecated
    public String getSpecifierContext() {
        return this.core_attributes.getContext(4);
    }

    @Deprecated
    public boolean hasSpecifierContext() {
        return this.core_attributes.hasContext(4);
    }

    public String getValue() {
        if (this.value_tagged == null) {
            this.value_tagged = TagManager.cleanOutput(TagManager.tag(this.mainRef.value, this.context));
        }
        return this.value_tagged;
    }

    public boolean hasValue() {
        return this.mainRef.value != null;
    }

    public ObjectTag getAlternative() {
        if (!this.hasAlternative()) {
            return null;
        }
        if (this.alternative_tagged != null) {
            return this.alternative_tagged;
        }
        this.alternative_tagged = TagManager.tagObject(this.mainRef.alternative, this.context);
        return this.alternative_tagged;
    }

    public boolean hasAlternative() {
        return this.mainRef.alternative != null;
    }

    public TagContext getContext() {
        return this.context;
    }

    public String getReplaced() {
        if (this.replaced == null && this.replaced_obj != null) {
            this.replaced = this.replaced_obj.toString();
        }
        return this.replaced;
    }

    public boolean isInstant() {
        return this.mainRef.isInstant;
    }

    public ScriptTag getScript() {
        return this.context.script;
    }

    public boolean replaced() {
        return this.wasReplaced && (this.replaced != null || this.replaced_obj != null);
    }

    public void setReplacedObject(ObjectTag obj) {
        this.replaced_obj = obj;
        this.replaced = null;
        this.wasReplaced = obj != null;
    }

    public void setReplaced(String string) {
        if (Debug.verbose) {
            try {
                throw new RuntimeException("Trace");
            }
            catch (Exception ex) {
                Debug.echoError(ex);
                Debug.log("Tag " + this.raw_tag + " updating to value: " + string);
            }
        }
        this.replaced = string;
        this.replaced_obj = null;
        this.wasReplaced = string != null;
    }

    public boolean hasScriptEntryAttached() {
        return this.context.entry != null;
    }

    public ScriptEntry getScriptEntry() {
        return this.context.entry;
    }

    public Attribute getAttributes() {
        return this.core_attributes;
    }

    public String toString() {
        return this.core_attributes.toString() + (this.hasValue() ? ":" + this.mainRef.value : "") + (this.hasAlternative() ? "||" + this.mainRef.alternative : "");
    }

    public static class ReferenceData {
        public boolean isInstant = false;
        public Attribute attribs = null;
        public String alternative = null;
        public String rawTag = null;
        public String value = null;
    }
}

