/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

public class UtilTagBase {
    public UtilTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                UtilTagBase.this.utilTag(event);
            }
        }, "util", "u");
    }

    public void utilTag(ReplaceableTagEvent event) {
        Attribute attribute;
        if (!event.matches("util", "u")) {
            return;
        }
        if (event.matches("u")) {
            Deprecations.utilShorthand.warn(event.getScriptEntry());
        }
        if ((attribute = event.getAttributes().fulfill(1)).startsWith("random")) {
            String stc;
            if ((attribute = attribute.fulfill(1)).startsWith("int")) {
                stc = attribute.getContext(1);
                if ((attribute = attribute.fulfill(1)).startsWith("to") && ArgumentHelper.matchesInteger(stc) && ArgumentHelper.matchesInteger(attribute.getContext(1))) {
                    int max;
                    int min = ArgumentHelper.getIntegerFrom(stc);
                    if (min > (max = ArgumentHelper.getIntegerFrom(attribute.getContext(1)))) {
                        int store = min;
                        min = max;
                        max = store;
                    }
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(String.valueOf(CoreUtilities.getRandom().nextInt(max - min + 1) + min)), attribute.fulfill(1)));
                }
            }
            if (attribute.startsWith("decimal") && attribute.hasContext(1)) {
                stc = attribute.getContext(1);
                if ((attribute = attribute.fulfill(1)).startsWith("to") && ArgumentHelper.matchesDouble(stc) && ArgumentHelper.matchesDouble(attribute.getContext(1))) {
                    double max;
                    double min = ArgumentHelper.getDoubleFrom(stc);
                    if (min > (max = ArgumentHelper.getDoubleFrom(attribute.getContext(1)))) {
                        double store = min;
                        min = max;
                        max = store;
                    }
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(String.valueOf(CoreUtilities.getRandom().nextDouble() * (max - min) + min)), attribute.fulfill(1)));
                }
            } else if (attribute.startsWith("decimal")) {
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(CoreUtilities.getRandom().nextDouble()), attribute.fulfill(1)));
            } else if (attribute.startsWith("gauss")) {
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(CoreUtilities.getRandom().nextGaussian()), attribute.fulfill(1)));
            } else if (attribute.startsWith("uuid")) {
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(UUID.randomUUID().toString()), attribute.fulfill(1)));
            } else if (attribute.startsWith("duuid")) {
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(attribute.hasContext(1) ? attribute.getContext(1) : ScriptQueue.getNextId("DUUID")), attribute.fulfill(1)));
            }
        } else if (attribute.startsWith("pi")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Math.PI), attribute.fulfill(1)));
        } else if (attribute.startsWith("tau")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Math.PI * 2), attribute.fulfill(1)));
        } else if (attribute.matches("e")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Math.E), attribute.fulfill(1)));
        } else if (attribute.matches("time_at") && attribute.hasContext(1)) {
            String[] dateComponents = attribute.getContext(1).split(" ");
            String[] ymd = dateComponents[0].split("/");
            int year = Integer.parseInt(ymd[0]);
            int month = Integer.parseInt(ymd[1]) - 1;
            int day = Integer.parseInt(ymd[2]);
            int hour = 0;
            int minute = 0;
            int second = 0;
            int millisecond = 0;
            if (dateComponents.length > 1) {
                String[] hms = dateComponents[1].split(":");
                hour = Integer.parseInt(hms[0]);
                minute = Integer.parseInt(hms[1]);
                second = Integer.parseInt(hms[2]);
                if (hms.length > 3) {
                    millisecond = Integer.parseInt(hms[3]);
                }
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month, day, hour, minute, second);
            DurationTag result = new DurationTag((double)(calendar.getTimeInMillis() + (long)millisecond) / 1000.0);
            event.setReplacedObject(result.getObjectAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("date")) {
            Calendar calendar = Calendar.getInstance();
            Date currentDate = new Date();
            SimpleDateFormat format = new SimpleDateFormat();
            if ((attribute = attribute.fulfill(1)).startsWith("time")) {
                if ((attribute = attribute.fulfill(1)).startsWith("twentyfour_hour")) {
                    format.applyPattern("k:mm");
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(format.format(currentDate)), attribute.fulfill(1)));
                } else if (attribute.startsWith("year")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(1)), attribute.fulfill(1)));
                } else if (attribute.startsWith("month")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(2) + 1), attribute.fulfill(1)));
                } else if (attribute.startsWith("week")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(3)), attribute.fulfill(1)));
                } else if (attribute.startsWith("day_of_week")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(7)), attribute.fulfill(1)));
                } else if (attribute.startsWith("day")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(5)), attribute.fulfill(1)));
                } else if (attribute.startsWith("hour")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(11)), attribute.fulfill(1)));
                } else if (attribute.startsWith("minute")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(12)), attribute.fulfill(1)));
                } else if (attribute.startsWith("second")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(13)), attribute.fulfill(1)));
                } else if (attribute.startsWith("duration")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new DurationTag(System.currentTimeMillis() / 50L), attribute.fulfill(1)));
                } else if (attribute.startsWith("zone")) {
                    TimeZone tz = Calendar.getInstance().getTimeZone();
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(tz.getDisplayName(tz.inDaylightTime(currentDate), 0)), attribute.fulfill(1)));
                } else if (attribute.startsWith("formatted_zone")) {
                    TimeZone tz = Calendar.getInstance().getTimeZone();
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(tz.getDisplayName(tz.inDaylightTime(currentDate), 1)), attribute.fulfill(1)));
                } else {
                    format.applyPattern("K:mm a");
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(format.format(currentDate)), attribute));
                }
            } else if (attribute.startsWith("format") && attribute.hasContext(1)) {
                try {
                    format.applyPattern(attribute.getContext(1));
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(format.format(currentDate)), attribute.fulfill(1)));
                }
                catch (Exception ex) {
                    Debug.echoError("Error: invalid pattern '" + attribute.getContext(1) + "'");
                    Debug.echoError(ex);
                }
            } else {
                format.applyPattern("EEE, MMM d, yyyy");
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(format.format(currentDate)), attribute));
            }
        }
    }

    public static void adjustSystem(Mechanism mechanism) {
        ElementTag value = mechanism.getValue();
        if (mechanism.matches("redirect_logging") && mechanism.hasValue()) {
            if (!DenizenCore.getImplementation().allowConsoleRedirection()) {
                Debug.echoError("Console redirection disabled by administrator.");
                return;
            }
            if (mechanism.getValue().asBoolean()) {
                DenizenCore.logInterceptor.redirectOutput();
            } else {
                DenizenCore.logInterceptor.standardOutput();
            }
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

