/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_14.impl.packets;

import com.denizenscript.denizen.nms.interfaces.packets.PacketOutChat;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_14_R1.ChatComponentText;
import net.minecraft.server.v1_14_R1.ChatMessageType;
import net.minecraft.server.v1_14_R1.IChatBaseComponent;
import net.minecraft.server.v1_14_R1.PacketPlayOutChat;

public class PacketOutChatImpl
implements PacketOutChat {
    private PacketPlayOutChat internal;
    private String message;
    private String rawJson;
    private boolean bungee;
    private ChatMessageType position;
    private static final Field MESSAGE;
    private static final Field POSITION;

    public PacketOutChatImpl(PacketPlayOutChat internal) {
        this.internal = internal;
        try {
            IChatBaseComponent baseComponent = (IChatBaseComponent)MESSAGE.get(internal);
            if (baseComponent != null) {
                this.message = baseComponent.getString();
                this.rawJson = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)baseComponent);
            } else {
                this.message = BaseComponent.toPlainText((BaseComponent[])internal.components);
                this.rawJson = ComponentSerializer.toString((BaseComponent[])internal.components);
                this.bungee = true;
            }
            this.position = (ChatMessageType)POSITION.get(internal);
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
        }
    }

    public int getPosition() {
        return this.position.ordinal();
    }

    public String getMessage() {
        return this.message;
    }

    public String getRawJson() {
        return this.rawJson;
    }

    public void setPosition(int position) {
        try {
            POSITION.set(this.internal, position);
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
        }
    }

    public void setMessage(String message) {
        try {
            if (!this.bungee) {
                MESSAGE.set(this.internal, new ChatComponentText(message));
            } else {
                this.internal.components = new BaseComponent[]{new TextComponent(message)};
            }
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
        }
    }

    public void setRawJson(String rawJson) {
        try {
            if (!this.bungee) {
                MESSAGE.set(this.internal, IChatBaseComponent.ChatSerializer.a((String)rawJson));
            } else {
                this.internal.components = ComponentSerializer.parse((String)rawJson);
            }
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
        }
    }

    static {
        Map fields = ReflectionHelper.getFields(PacketPlayOutChat.class);
        MESSAGE = (Field)fields.get("a");
        POSITION = (Field)fields.get("b");
    }
}

