/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.scripts.containers.core.VersionScriptContainer;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.ScriptVersionChecker;
import com.denizenscript.denizen.utilities.command.Command;
import com.denizenscript.denizen.utilities.command.CommandContext;
import com.denizenscript.denizen.utilities.command.Paginator;
import com.denizenscript.denizen.utilities.command.exceptions.CommandException;
import com.denizenscript.denizen.utilities.command.messaging.Messaging;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.debugging.DebugSubmit;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.debugging.FutureWarning;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DenizenCommandHandler {
    private final Denizen denizen;

    public DenizenCommandHandler(Denizen denizen) {
        this.denizen = denizen;
    }

    @Command(aliases={"denizen"}, usage="submit", desc="Submits recorded logs triggered by /denizen debug -r", modifiers={"submit"}, min=1, max=3, permission="denizen.submit")
    public void submit(CommandContext args, final CommandSender sender) throws CommandException {
        if (!Debug.record) {
            Messaging.sendError(sender, "Use /denizen debug -r  to record debug information to be submitted");
            return;
        }
        Debug.record = false;
        Messaging.send(sender, "Submitting...");
        final DebugSubmit submit = new DebugSubmit();
        submit.recording = Debug.Recording.toString();
        Debug.Recording = new StringBuilder();
        submit.start();
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                if (!submit.isAlive()) {
                    if (submit.Result == null) {
                        Messaging.sendError(sender, "Error while submitting.");
                    } else {
                        Messaging.send(sender, "Successfully submitted to https://one.denizenscript.com" + submit.Result);
                    }
                    this.cancel();
                }
            }
        };
        task.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 0L, 10L);
    }

    @Command(aliases={"denizen"}, usage="debug", desc="Toggles debug mode for Denizen.", modifiers={"debug", "de", "db", "dbug"}, min=1, max=5, permission="denizen.debug", flags="scebrxovnipf")
    public void debug(CommandContext args, CommandSender sender) throws CommandException {
        if (args.hasFlag('s')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            Debug.showStackTraces = !Debug.showStackTraces;
            Messaging.sendInfo(sender, Debug.showStackTraces ? "Denizen debugger is now showing caught exception stack traces." : "Denizen debugger is now hiding caught stacktraces.");
        }
        if (args.hasFlag('c')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            Debug.showColor = !Debug.showColor;
            Messaging.sendInfo(sender, Debug.showColor ? "Denizen debugger is now showing color." : "Denizen debugger color has been disabled.");
        }
        if (args.hasFlag('o')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            Debug.debugOverride = !Debug.debugOverride;
            Messaging.sendInfo(sender, Debug.debugOverride ? "Denizen debugger is now overriding 'debug: false'." : "Denizen debugger override has been disabled.");
        }
        if (args.hasFlag('e')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            com.denizenscript.denizencore.utilities.debugging.Debug.showEventsTrimming = !com.denizenscript.denizencore.utilities.debugging.Debug.showEventsTrimming;
            Messaging.sendInfo(sender, com.denizenscript.denizencore.utilities.debugging.Debug.showEventsTrimming ? "Denizen debugger is now logging all world events." : "Denizen debugger is now hiding world events.");
        }
        if (args.hasFlag('b')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            com.denizenscript.denizencore.utilities.debugging.Debug.showScriptBuilder = !com.denizenscript.denizencore.utilities.debugging.Debug.showScriptBuilder;
            Messaging.sendInfo(sender, com.denizenscript.denizencore.utilities.debugging.Debug.showScriptBuilder ? "Denizen debugger is now logging the ScriptBuilder." : "Denizen debugger is now hiding ScriptBuilder logging.");
        }
        if (args.hasFlag('r')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            Debug.record = !Debug.record;
            Debug.Recording = new StringBuilder();
            Messaging.sendInfo(sender, Debug.record ? "Denizen debugger is now recording. Use /denizen submit to finish." : "Denizen debugger recording disabled.");
        }
        if (args.hasFlag('v')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            com.denizenscript.denizencore.utilities.debugging.Debug.verbose = !com.denizenscript.denizencore.utilities.debugging.Debug.verbose;
            Messaging.sendInfo(sender, com.denizenscript.denizencore.utilities.debugging.Debug.verbose ? "Denizen debugger is now verbose." : "Denizen debugger verbosity disabled.");
        }
        if (args.hasFlag('f')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            FutureWarning.futureWarningsEnabled = !FutureWarning.futureWarningsEnabled;
            Messaging.sendInfo(sender, FutureWarning.futureWarningsEnabled ? "Denizen debugger is now showing future warnings." : "Denizen debugger future-warnings disabled.");
        }
        if (args.hasFlag('x')) {
            Debug.filter = new ArrayList<String>();
            Messaging.sendInfo(sender, "Denizen debugger filter removed.");
        }
        if (args.hasFlag('n')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            Debug.shouldTrim = !Debug.shouldTrim;
            Messaging.sendInfo(sender, Debug.shouldTrim ? "Denizen debugger is now trimming long messages." : "Denizen debugger is no longer trimming long messages.");
        }
        if (args.hasFlag('i')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            Debug.showSources = !Debug.showSources;
            Messaging.sendInfo(sender, Debug.showSources ? "Denizen debugger is now showing packet logs." : "Denizen debugger is no longer showing packet logs.");
        }
        if (args.hasFlag('p')) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            NMSHandler.debugPackets = !NMSHandler.debugPackets;
            Messaging.sendInfo(sender, NMSHandler.debugPackets ? "Denizen debugger is now showing source information." : "Denizen debugger is no longer showing source information.");
        }
        if (args.hasValueFlag("filter")) {
            if (!Debug.showDebug) {
                Debug.toggle();
            }
            for (String filter : args.getFlag("filter").split("\\|")) {
                Debug.filter.add(filter);
            }
            Messaging.sendInfo(sender, "Denizen debugger filter now: " + Debug.filter.toString());
        } else if (args.getFlags().isEmpty()) {
            Debug.toggle();
            Messaging.sendInfo(sender, "Denizen debugger is now: " + (Debug.showDebug ? "<a>ENABLED" : "<c>DISABLED"));
        }
    }

    @Command(aliases={"denizen"}, usage="do_nothing", desc="Does nothing, for better server command handling", modifiers={"do_nothing"}, min=1, max=3, permission="denizen.basic")
    public void do_nothing(CommandContext args, CommandSender sender) throws CommandException {
    }

    @Command(aliases={"denizen"}, usage="version", desc="Shows the currently loaded version of Denizen.", modifiers={"version"}, min=1, max=3, permission="denizen.basic")
    public void version(CommandContext args, CommandSender sender) throws CommandException {
        Messaging.sendInfo(sender, "<2>DENIZEN<7>: scriptable Minecraft!");
        Messaging.send(sender, "");
        Messaging.send(sender, "<7>by: <f>the DenizenScript team, with help from many skilled contributors!");
        Messaging.send(sender, "<7>chat with us at: <f> https://discord.gg/Q6pZGSR");
        Messaging.send(sender, "<7>or learn more at: <f> https://denizenscript.com");
        Messaging.send(sender, "<7>version: <f>" + Denizen.versionTag + "<7>, core version: <f>" + DenizenCore.VERSION);
    }

    @Command(aliases={"denizen"}, usage="scriptversions", desc="Shows the currently loaded version of your scripts and checks them against the script repo.", modifiers={"scriptversions"}, min=1, max=3, permission="denizen.basic")
    public void scriptcheck(CommandContext args, CommandSender sender) throws CommandException {
        sender.sendMessage(ChatColor.GREEN + "Checking " + VersionScriptContainer.scripts.size() + " script(s)!");
        for (VersionScriptContainer cont : VersionScriptContainer.scripts) {
            ScriptVersionChecker svc = new ScriptVersionChecker(cont);
            svc.runme(sender);
        }
    }

    @Command(aliases={"denizen"}, usage="save", desc="Saves the current state of Denizen/saves.yml.", modifiers={"save"}, min=1, max=3, permission="denizen.basic", flags="s")
    public void save(CommandContext args, CommandSender sender) throws CommandException {
        DenizenAPI.getCurrentInstance().saveSaves();
        Messaging.send(sender, "Denizen/saves.yml saved to disk from memory.");
    }

    @Command(aliases={"denizen"}, usage="reload (saves|notables|config|scripts) (-a)", desc="Reloads various Denizen files from disk to memory.", modifiers={"reload"}, min=1, max=3, permission="denizen.basic", flags="a")
    public void reload(CommandContext args, CommandSender sender) throws CommandException {
        if (args.hasFlag('a')) {
            this.denizen.reloadConfig();
            DenizenCore.reloadScripts();
            this.denizen.notableManager().reloadNotables();
            this.denizen.reloadSaves();
            Messaging.send(sender, "Denizen/saves.yml, Denizen/notables.yml, Denizen/config.yml, and Denizen/scripts/... reloaded from disk to memory.");
            if (ScriptHelper.hadError()) {
                Messaging.sendError(sender, "There was an error loading your scripts, check the console for details!");
            }
            return;
        }
        if (args.length() > 2) {
            if (args.getString(1).equalsIgnoreCase("saves")) {
                this.denizen.reloadSaves();
                Messaging.send(sender, "Denizen/saves.yml reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("notables")) {
                this.denizen.notableManager().reloadNotables();
                Messaging.send(sender, "Denizen/notables.yml reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("config")) {
                this.denizen.reloadConfig();
                Messaging.send(sender, "Denizen/config.yml reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("scripts")) {
                DenizenCore.reloadScripts();
                Messaging.send(sender, "Denizen/scripts/... reloaded from disk to memory.");
                if (ScriptHelper.hadError()) {
                    Messaging.sendError(sender, "There was an error loading your scripts, check the console for details!");
                }
                Messaging.sendError(sender, "'/denizen reload scripts' is the old way of doing things ... use '/ex reload' instead!");
                return;
            }
        }
        Messaging.send(sender, "");
        Messaging.send(sender, "<f>Specify which parts to reload. Valid options are: SAVES, NOTABLES, CONFIG, SCRIPTS");
        Messaging.send(sender, "<b>Example: /denizen reload scripts");
        Messaging.send(sender, "<f>Use '-a' to reload all parts.");
        Messaging.send(sender, "");
    }

    @Command(aliases={"denizen"}, usage="scripts (--type assignment|task|...) (--filter string)", desc="Lists currently loaded dScripts.", modifiers={"scripts"}, min=1, max=4, permission="denizen.basic")
    public void scripts(CommandContext args, CommandSender sender) throws CommandException {
        String type = null;
        if (args.hasValueFlag("type")) {
            type = args.getFlag("type");
        }
        String filter = null;
        if (args.hasValueFlag("filter")) {
            filter = args.getFlag("filter");
        }
        Set<String> scripts = ScriptRegistry._getScriptNames();
        Paginator paginator = new Paginator().header("Scripts");
        paginator.addLine("<e>Key: <a>Type  <b>Name");
        for (String script : scripts) {
            Object scriptContainer = ScriptRegistry.getScriptContainer(script);
            if (type != null) {
                if (!((ScriptContainer)scriptContainer).getContainerType().equalsIgnoreCase(type)) continue;
                if (filter != null) {
                    if (!script.contains(filter.toUpperCase())) continue;
                    paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                    continue;
                }
                paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                continue;
            }
            if (filter != null) {
                if (!script.contains(filter.toUpperCase())) continue;
                paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                continue;
            }
            paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
        }
        if (!paginator.sendPage(sender, args.getInteger(1, 1))) {
            throw new CommandException("The page " + args.getInteger(1, 1) + " does not exist.");
        }
    }

    @Command(aliases={"notable"}, usage="add", desc="Adds a new notable to your current location", modifiers={"add", "save"}, min=2, max=20, permission="denizen.notable.basic")
    public void addnotable(CommandContext args, CommandSender sender) throws CommandException {
        NotableManager.saveAs(new LocationTag(((Player)sender).getLocation()), args.getString(1));
        Messaging.send(sender, "Created new notable called " + args.getString(1));
    }

    @Command(aliases={"notable"}, usage="list", desc="Lists all notable locations", modifiers={"list"}, min=1, max=1, permission="denizen.notable.basic")
    public void listnotable(CommandContext args, CommandSender sender) throws CommandException {
        Messaging.send(sender, NotableManager.getAllType(LocationTag.class).toString());
    }
}

