/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceSmeltEvent;

public class FurnaceSmeltsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static FurnaceSmeltsItemScriptEvent instance;
    public ItemTag source_item;
    public ItemTag result_item;
    public LocationTag location;
    public FurnaceSmeltEvent event;

    public FurnaceSmeltsItemScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("furnace smelts");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryItem(this.source_item, path.eventArgLowerAt(2))) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("into") && !this.tryItem(this.result_item, path.eventArgLowerAt(4))) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "FurnaceSmelts";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ItemTag.matches(determination)) {
            this.result_item = ItemTag.valueOf(determination, path.container);
            this.event.setResult(this.result_item.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("source_item")) {
            return this.source_item;
        }
        if (name.equals("result_item")) {
            return this.result_item;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onFurnaceSmelts(FurnaceSmeltEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.source_item = new ItemTag(event.getSource());
        this.result_item = new ItemTag(event.getResult());
        this.event = event;
        this.fire((Event)event);
    }
}

