/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.entity.Position;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;

public class EntityShootsBowEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityShootsBowEvent instance;
    public EntityTag entity;
    public Float force;
    public ItemTag bow;
    public EntityTag projectile;
    public EntityShootBowEvent event;

    public EntityShootsBowEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("shoots");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String attacker = path.eventArgLowerAt(0);
        String item = path.eventArgLowerAt(2);
        if (!this.tryEntity(this.entity, attacker)) {
            return false;
        }
        if (!item.equals("bow") && !this.tryItem(this.bow, item)) {
            return false;
        }
        return this.runInCheck(path, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityShootsBow";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (Argument.valueOf(determination).matchesArgumentList(EntityTag.class)) {
            this.cancelled = true;
            List<EntityTag> newProjectiles = ListTag.getListFor(determinationObj).filter(EntityTag.class, path.container, true);
            for (EntityTag newProjectile : newProjectiles) {
                newProjectile.spawnAt(this.entity.getEyeLocation().add(this.entity.getEyeLocation().getDirection()));
                if (!newProjectile.isProjectile()) continue;
                newProjectile.setShooter(this.entity);
            }
            Position.mount(Conversion.convertEntities(newProjectiles));
            Entity lastProjectile = newProjectiles.get(newProjectiles.size() - 1).getBukkitEntity();
            lastProjectile.setVelocity(this.event.getEntity().getLocation().getDirection().multiply(this.force.floatValue()));
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? EntityTag.getPlayerFrom((Entity)this.event.getEntity()) : null, this.entity.isCitizensNPC() ? EntityTag.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("force")) {
            return new ElementTag(this.force.floatValue());
        }
        if (name.equals("bow")) {
            return this.bow;
        }
        if (name.equals("projectile")) {
            return this.projectile;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityShootsBow(EntityShootBowEvent event) {
        this.entity = new EntityTag((Entity)event.getEntity());
        this.force = Float.valueOf(event.getForce() * 3.0f);
        this.bow = new ItemTag(event.getBow());
        Entity projectileEntity = event.getProjectile();
        EntityTag.rememberEntity(projectileEntity);
        this.projectile = new EntityTag(projectileEntity);
        this.event = event;
        this.fire((Event)event);
        EntityTag.forgetEntity(projectileEntity);
    }
}

