/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTameEvent;

public class EntityTamesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityTamesScriptEvent instance;
    public EntityTag entity;
    public EntityTag owner;
    public EntityTameEvent event;

    public EntityTamesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.xthArgEquals(1, lower, "tames");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String tamed;
        String cmd = path.eventArgLowerAt(1);
        String ownerTest = cmd.equals("tames") ? path.eventArgLowerAt(0) : path.eventArgLowerAt(2);
        String string = tamed = cmd.equals("tamed") ? path.eventArgLowerAt(0) : path.eventArgLowerAt(2);
        if (!this.tryEntity(this.owner, ownerTest) || !this.tryEntity(this.entity, tamed)) {
            return false;
        }
        return this.runInCheck(path, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityTames";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.owner.isPlayer() ? this.owner.getDenizenPlayer() : null, this.owner.isCitizensNPC() ? this.owner.getDenizenNPC() : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("owner")) {
            return this.owner;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityTames(EntityTameEvent event) {
        this.entity = new EntityTag((Entity)event.getEntity());
        this.owner = new EntityTag((Entity)event.getOwner());
        this.event = event;
        this.fire((Event)event);
    }
}

