/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class EntityTeleportScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityTeleportScriptEvent instance;
    public EntityTag entity;
    public LocationTag from;
    public LocationTag to;
    public String cause;
    public EntityTeleportEvent event;
    public PlayerTeleportEvent pEvent;

    public EntityTeleportScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.xthArgEquals(1, lower, "teleports");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.runGenericSwitchCheck(path, "cause", this.cause)) {
            return false;
        }
        return this.runInCheck(path, this.from);
    }

    @Override
    public String getName() {
        return "EntityTeleports";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        LocationTag new_to;
        String determination = determinationObj.toString();
        String dlow = CoreUtilities.toLowerCase(determination);
        if (dlow.startsWith("origin:")) {
            LocationTag new_from = LocationTag.valueOf(determination.substring("origin:".length()));
            if (new_from != null) {
                this.from = new_from;
                return true;
            }
        } else if (dlow.startsWith("destination:")) {
            LocationTag new_to2 = LocationTag.valueOf(determination.substring("destination:".length()));
            if (new_to2 != null) {
                this.to = new_to2;
                return true;
            }
        } else if (LocationTag.matches(determination) && (new_to = LocationTag.valueOf(determination)) != null) {
            this.to = new_to;
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.pEvent != null ? EntityTag.getPlayerFrom((Entity)this.pEvent.getPlayer()) : null, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("origin")) {
            return this.from;
        }
        if (name.equals("destination")) {
            return this.to;
        }
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("cause")) {
            return new ElementTag(this.cause);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityTeleports(EntityTeleportEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        this.to = new LocationTag(event.getTo());
        this.from = new LocationTag(event.getFrom());
        this.entity = new EntityTag(event.getEntity());
        this.cause = "ENTITY_TELEPORT";
        this.event = event;
        this.pEvent = null;
        this.fire((Event)event);
        event.setFrom((Location)this.from);
        event.setTo((Location)this.to);
    }

    @EventHandler
    public void onPlayerTeleports(PlayerTeleportEvent event) {
        this.from = new LocationTag(event.getFrom());
        this.to = new LocationTag(event.getTo());
        this.entity = new EntityTag((Entity)event.getPlayer());
        this.cause = event.getCause().name();
        this.event = null;
        this.pEvent = event;
        this.fire((Event)event);
        event.setFrom((Location)this.from);
        event.setTo((Location)this.to);
    }
}

